;;;
;;; enesperantigu.el  Versio 1.2  1994-3-14
;;;
;;; Verkinto: Marko Rauhamaa
;;;
;;; Uzu libere por kiu ajn celo.
;;;

(defconst enesperantigordono "enesperantigu" "La ordono de enesperantigado.")
(defconst elesperantigordono "elesperantigu" "La ordono de elesperantigado.")

(defvar enesperantigu-kvankam-neenskribebla nil
  "*Se i tiu varianto estas ne-nil, la ordonoj enesperantigu-bufron
kaj elesperantigubufron anas la enhavon de la bufro e se i estas
neenskribebla.")

(defun enesperantigu-bufron ()
  "Traduku la bufron sekve:

  cx, ch, ^c, c~ --> 
  gx, gh, ^g, g~ --> 
  ktp.
  ux, ^u, u~, w --> .

Vidu anka la varianton enesperantigu-kvankam-neenskribebla kaj
la ordonon elesperantigu-bufron."
  (interactive)
  (if (and buffer-read-only (not enesperantigu-kvankam-neenskribebla))
      (error "Bufro estas neenskribebla (enesperantigu-kvankam-neenskribebla estas nil)")
    (let ((buffer-read-only nil))
      (save-excursion
	(shell-command-on-region (point-min) (point-max)
				 enesperantigordono t)))))

(defun elesperantigu-bufron ()
  "Traduku la bufron sekve:

   --> cx
   --> gx
  ktp.
   --> ux.

Vidu anka la varianton enesperantigu-kvankam-neenskribebla kaj
la ordonon enesperantigu-bufron."
  (interactive)
  (if (and buffer-read-only (not enesperantigu-kvankam-neenskribebla))
      (error "Bufro estas neenskribebla (enesperantigu-kvankam-neenskribebla estas nil)")
    (let ((buffer-read-only nil))
      (save-excursion
	(shell-command-on-region (point-min) (point-max)
				 elesperantigordono t)))))

(defun enesperantigu-alian-bufron (argumento)
  "Vokas enesperantigu-bufron en la sekva bufro en la ciklo
de la nuna fenestro. La lavola argumento difinas la bufron."
  (interactive "p")
  (other-window argumento)
  (enesperantigu-bufron)
  (other-window (- argumento)))

(defun elesperantigu-alian-bufron (argumento)
  "Vokas elesperantigu-bufron en la sekva bufro en la ciklo
de la nuna fenestro. La lavola argumento difinas la bufron."
  (interactive "p")
  (other-window argumento)
  (elesperantigu-bufron)
  (other-window (- argumento)))
