;---------------------------------------------------------------------
; "Klavint" faciligas la tajpadon de esperantaj supersignitaj literoj
; por IBM-uzantoj. Gxi estas DOS-programo. Gxi ne funkcias en
; "Windows".
;---------------------------------------------------------------------
; Kiel uzi:
;
; Funkciigu "klavint" nur unufoje post sxalto de la komputilo:
;
; C:>klavint
; Klavint 1.1 --- Klivo 1994
; Bonvolu legi klavint.asm por instrukcioj.
; C:>
;
; Klavint' restos en memoro kaj funkcios, dum vi uzas aliajn programojn.
;
; Por fari supersignitan literon, tajpu la punktokomon ";" kaj la
; literon. Ekzemple, por fari la vorton ^cirka^u, tajpu ;cirka;u . 
; Klavint konvertos ;c kaj ;u al la gxustaj kodoj. 
;
; Kiam klavint' ekfunkcias, gxi estas en Latin-3-modo. Gxi auxtomate
; konvertas ;c al la gxusta kodo por cxo en Latin-3. Por sxangxi la modon
; al WordPerfect 5, tajpu punktokomon kaj 5 ";5". 
;
; Jen la diversaj modoj:
;
;  Tajpu ;3 por Latin-3 (ISO 8859-3).
;  Tajpu ;5 por WordPerfect 5 (aux 6).
;  Tajpu ;6 por WordPerfect 6 (aux 5).
;  Tajpu ;^ por cirkumfleks-modo (^cirka^u).
;  Tajpu ;X por iks-modo (cxirkaux).     Notu: la X devas esti majuskla X
;
; Se vi volas enigi ;c kaj ne volas, ke gxi estu konvertita al supersignita 
; litero, tajpu ; kaj spacon. Tiam forvisxu la spacon kaj tajpu c.
;
;---------------------------------------------------------------------
; Rajtoj:
; Oni rajtas uzi kaj sxangxi cxi tiun programon lauxplacxe, sed oni ne
; rajtas forigi cxi tiujn komentojn.
; Klavint estas senpaga. Oni ne rajtas vendi gxin aux partojn de gxi.
; Oni rajtas disdoni la programon. Se vi disdonos sxangxitan version,
; bonvolu indiki, ke vi sxangxis gxin en la sekcio pri historio (sube).
;---------------------------------------------------------------------
; Kiel kontakti min:
;
; Retadreso:   cleve.lendon@canrem.com    (gxis junio 1994)
; Hejmadreso:  Klivo Lendon
;              608 Beresford Ave.
;              Toronto, Ontario
;              Canada
;              M6S 3C3
;
; Post junio 1994:
;
;              Klivo Lendon
;              1-15-2 Tama-machi
;              Fuchu-shi
;              Tokyo 183
;              Japan                 
;---------------------------------------------------------------------
; Historio
; Dato       Fusxinto            Komentoj 
; --------   ------------------  -------------------------------------
; 1994/02    Klivo               Unua versio.
; 1994/03    Klivo               Gardas tro da memoro (funkcio 31h)
;
;
;

;---------------------------------------------------------------------
; Konstantoj
;---------------------------------------------------------------------

; Maskoj por kl_flago, indikas cxu sxangx-klavo estas aktiva aux ne.
; (La sxlosoklavoj estas aktivaj post premo, la aliaj estas
; aktivaj nur dum premo.)

en_sxlo       equ   80h       ; ensxova sxlosoklavo  
maj_sxlo      equ   40h       ; majuskliga sxlosoklavo
num_sxlo      equ   20h       ; numera sxlosoklavo
rul_sxlo      equ   10h       ; rula sxlosoklavo
alt_klavo     equ   08h       ; alternativ-klavo
ord_klavo     equ   04h       ; ordon-klavo (ctrl)
maldekstro    equ   02h       ; maldekstra majuskliga klavo
dekstro       equ   01h       ; dekstra majuskliga klavo

; La klavbufro enhavas du bajtojn por cxiu premita klavo. La skan-kodo 
; estas in la alta bajto kaj la aski-kodo estas en la malalta bajto.

retropasxo    equ   0e08h 
ord_2         equ   0300h     ; ctrl-2
ord_w         equ   1117h     ; ctrl-w
n0            equ   0b30h
n1            equ   0231h
n2            equ   0332h
n3            equ   0433h
n4            equ   0534h
n5            equ   0635h
n6            equ   0736h
n7            equ   0837h
n8            equ   0938h
n9            equ   0a39h
komo          equ   332ch
reiro         equ   1c0dh
cirkumflekso  equ   075eh
maj_c         equ   2e43h     ; majuskla c
min_c         equ   2e63h     ; minuskla c
maj_g         equ   2247h
min_g         equ   2267h
maj_h         equ   2348h
min_h         equ   2368h
maj_j         equ   244ah
min_j         equ   246ah
maj_s         equ   1f53h
min_s         equ   1f73h
maj_u         equ   1655h
min_u         equ   1575h
min_x         equ   2d78h

lat3_modo     equ   0         ; Latin-3 (ISO 8859-3)
wp5_modo      equ   1         ; WordPerfect 5 / VortPerfekto 5
wp6_modo      equ   2         ; WordPerfect 6 / VortPerfekto 6
cf_modo       equ   3         ; cirkumfleks-modo
x_modo        equ   4         ; iks-modo

;---------------------------------------------------------------------
; Segmentoj
;---------------------------------------------------------------------

biosdateno  segment   byte at 40H ; Bios-dateno cxe 400H

            org  0017h
kl_flago    db   ?       ; klavara flago
kl_flago1   db   ?
alt_enigo   db   ?
kapo        dw   ?       ; kapomontrilo por klav-bufro
vosto       dw   ?       ; vostomontrilo por klav-bufro

            org  0080h
malsupro    dw   ?		; malsupro de klav-bufro
supro       dw   ?       ; supro de klav-bufro + 1

biosdateno  ends

kodseg    segment public byte
		assume	cs:kodseg, ds:kodseg

;---------------------------------------------------------------------
; Komenco de "klavint"
;---------------------------------------------------------------------

           org     100h

komenco:   jmp     pretigu

malnova16  dd      0        ; adreso de malnova interrompo 16h

cghjsu     db      'CcGgHhJjSsUu'  ; literoj, kiuj povas havi supersignon

; Kod-tabeloj entenas la kodoj por supersignitaj literoj. Cxiu "vorto" 
; entenas skan-kodon kaj aski-kodon.

; Latin-3 (ISO 8859-3) kod-tabelo
latin_3    dw      2ec6h,2ee6h,22d8h,22f8h,23a6h,23b6h
           dw      24ach,24bch,1fdeh,1ffeh,16ddh,16fdh

; WordPerfect 5  Vortperfekto 5 kod-tabelo
wp6        label   word             ; la kodoj estas samaj
wp5        dw      ord_2,n1,komo,n1,n0,n0,reiro,0
           dw      ord_2,n1,komo,n1,n0,n1,reiro,0   
           dw      ord_2,n1,komo,n1,n2,n2,reiro,0
           dw      ord_2,n1,komo,n1,n2,n3,reiro,0
           dw      ord_2,n1,komo,n1,n2,n6,reiro,0   
           dw      ord_2,n1,komo,n1,n2,n7,reiro,0
           dw      ord_2,n1,komo,n1,n4,n0,reiro,0   
           dw      ord_2,n1,komo,n1,n4,n1,reiro,0
           dw      ord_2,n1,komo,n1,n8,n0,reiro,0
           dw      ord_2,n1,komo,n1,n8,n1,reiro,0
           dw      ord_2,n1,komo,n1,n8,n8,reiro,0
           dw      ord_2,n1,komo,n1,n8,n9,reiro,0

; kodoj for cirkumfleks-modo 
cf_tab     dw      cirkumflekso,maj_c
           dw      cirkumflekso,min_c
           dw      cirkumflekso,maj_g
           dw      cirkumflekso,min_g
           dw      cirkumflekso,maj_h
           dw      cirkumflekso,min_h
           dw      cirkumflekso,maj_j
           dw      cirkumflekso,min_j
           dw      cirkumflekso,maj_s
           dw      cirkumflekso,min_s
           dw      cirkumflekso,maj_u
           dw      cirkumflekso,min_u

; kodoj for iks-modo 
x_tab      dw      maj_c,min_x
           dw      min_c,min_x
           dw      maj_g,min_x
           dw      min_g,min_x
           dw      maj_h,min_x
           dw      min_h,min_x
           dw      maj_j,min_x
           dw      min_j,min_x
           dw      maj_s,min_x
           dw      min_s,min_x
           dw      maj_u,min_x
           dw      min_u,min_x

pk_flago   db      0          ; punkto-komo flago
kod_adr    dw      0          ; montrilo al kodo en kod-tabelo
kod_nom    dw      0          ; nombro da kodoj por sendi
modo       db      lat3_modo  ; modo de programo: latin-3, wp5, wp6 ktp.

mesagxo    db      'Klavint 1.1 --- Klivo 1994',10,13
           db      'Bonvolu legi klavint.asm por instrukcioj.',10,13,'$'

instalita  db      'Klavint jam estas instalita.',10,13,'$'

;---------------------------------------------------------------------
; Nova klavara interromp-rutino
;---------------------------------------------------------------------

klavint   proc    far
          sti                    ; ebligu interrompojn

          push    bx             ; konservu registrojn
          push    cx
          push    dx
          push    di
          push    si
          push    ds
          push    es

          push    cs
          pop     ds             ; ds = cs

          pushf                  ; konservu flagojn

                                 ; 'kl' estas funkcio kiu indikas, ke
          cmp     ax,'kl'        ; klavint' jam aktivas.
          jne     k9             ; saltu se ax <> 'kl'
          mov     ax,'KL'
          jmp     eliro
                                 ; kontrolu la funkci-numeron
k9:       cmp     ah,1           ; cxu funkcio estas "kontrolu bufron" ?
          je      k5             ; saltu se jes
          cmp     ah,11h         ; plibonigita kontrolo ?
          jne     k6             ; saltu se ne

; Kontrolu cxu estas klavo en al klav-bufro, aux cxu "klavint" volas
; sendi kodojn por supersignita litero.

k5:       mov     bx, kod_nom    ; cxu klavint havas kodojn por sendi?
          or      bx,bx          ; (kod-nombro > 0 ?)
          jz      k7             ; saltu se ne
                                 ; jes, estas kodoj
          popf                   
          or      bx,bx          ; Z-flago = 0
          jmp     eliro2         ; reiru
         
k6:       cmp     ah,0           ; cxu la funkcio estas "lego" ?
          je      k3             ; saltu se jes
          cmp     ah,10h         ; cxu la funkcio estas "plibonigita lego" ?
          je      k3             ; saltu se jes

; La funkcio ne estas "lego". Voku la malnovan interromp-rutinon kaj eliru.

k7:       popf                   ; reakiru flagojn
          pushf                  ; sxajnigu interrompon
          cli                    ; malebligu interrompojn, mi ne scias kial
          call    cs:malnova16   ; voku malnovan interromp-rutinon
          jmp     eliro2         

; La funkcio ja estas "lego".

k3:       popf

; kontrolu, cxu ni devas elsendi supersignitan literon (kod-nombro > 0)

          mov     bx, kod_nom    ; akiru la kod-nombron
          or      bx,bx          ; > 0 ?
          jz      k4             ; saltu se ne

; Jes, oni devas elsendi supersignitan literon. Akiru la kodon.

          mov     di, kod_adr    ; akiru la kod-adreson
          mov     ax,[di]        ; akiru la kodon el la kod-tabelo
          inc     di             ; montru al sekvanta kodo
          inc     di
          mov     kod_adr, di
          dec     bx             ; kod-nombro - 1
          mov     kod_nom, bx
          jmp     eliro2         ; reiru

; Ne estas supersignita litero por elsendi. Voku la malnovan interromp-
; rutinon por kontroli la klav-bufron.

k4:       pushf                  ; sxajnigu interrompon
          cli                    ; malebligu interrompojn, mi ne scias kial
          call    cs:malnova16   ; voku malnovan interromp-rutinon
          pushf                  ; konservu flagojn

k1:       cmp     pk_flago,0     ; cxu antauxa karaktro estis punktokomo?
          je      k2             ; saltu se ne

; Antauxa karaktro estis punktokomo. Cxu la legata karaktro bezonas 
; supersignon?

          push    cs
          pop     es             ; es = cs
          cld                    ; direkto - antauxen
          mov     di, offset cghjsu  ; di montras al supersigneblaj literoj
          mov     cx, 12         ; 12 literoj, majuskloj kaj minuskloj
          repne   scasb          ; skanu la tabelon
          je      k8             ; saltu se trovita

; Eble la uzanto sxangxas la modon. ;3 = latin3 ;5 = WP5 ktp.

          cmp     al,'3'         ; cxu latin 3 (;3) ? 
          jne     m1             ; saltu se ne
          mov     modo,lat3_modo ; la modo estas latin3
          jmp     k_visxu        ; forigu la punktokomon
m1:       cmp     al,'5'         ; cxu WP5 ? 
          jne     m2             ; saltu se ne
          mov     modo, wp5_modo ; la modo estas "WordPerfect 5"
          jmp     k_visxu        ; forigu la punktokomon
m2:       cmp     al,'6'         ; cxu WP6 ? 
          jne     m3             ; saltu se ne
          mov     modo, wp6_modo ; la modo estas "WordPerfect 6"
          jmp     k_visxu        ; forigu la punktokomon
m3:       cmp     al,'^'         ; cxu cirkumfleks-modo
          jne     m4             ; saltu se ne
          mov     modo, cf_modo  ; modo estas cirkumfleks-modo ^c
          jmp     k_visxu
m4:       cmp     al, 'X'        ; cxu iks-modo?
          jne     k2             ; saltu se ne
          mov     modo, x_modo   ; modo estas iks-modo cx
          jmp     k_visxu

; La programo devas elsendi klav-kodojn por montrigi supersignitajn 
; literojn. Kalkulu la nombron kaj la adreson de la kodoj por
; elsendi.

k8:       sub     di, offset cghjsu + 1  ; kalkulu indekson

          mov     al, modo       ; latin-3 aux wp modo?
          cmp     al, wp5_modo
          je      k_wp5          ; saltu se modo estas WordPerfect 5
          cmp     al, wp6_modo
          je      k_wp6          ; saltu se modo estas WordPerfect 6
          cmp     al, cf_modo
          je      k_cf           ; saltu se estas cirkumfleks-modo
          cmp     al, x_modo
          je      k_x            ; saltu se estas iks-modo

; Modo estas Latin-3 
k_lat3:   sal     di,1           ; indekso * 2
          mov     ax, offset latin_3   ; bazo de tabelo
          add     ax,di
          mov     kod_adr, ax    ; adreso de unua klav-kodo por elsendi
          mov     kod_nom, 1     ; nombro da kodoj por elsendi
          jmp     k_visxu        ; forvisxu la antauxan karaktron

; Modo estas WordPerfect 5
k_wp5:    sal     di,1           ; indekso * 2 * 8
          sal     di,1
          sal     di,1
          sal     di,1
          mov     ax, offset wp5 ; bazo de tabelo
          jmp     k_wp
; Modo estas WordPerfect 6
k_wp6:    sal     di,1           ; indekso * 2 * 8
          sal     di,1
          sal     di,1
          sal     di,1
          mov     ax, offset wp6 ; bazo de tabelo
k_wp:     add     ax,di
          mov     kod_adr, ax    ; adreso de unua klav-kodo por elsendi
          mov     kod_nom, 7     ; elsendu 7 kodojn
          jmp     k_visxu        ; forvisxu la punktokomon

; Modo estas cirkumfleks-modo
k_cf:     sal     di,1           ; indekso * 2 * 2
          sal     di,1
          mov     ax, offset cf_tab  ; bazo de tabelo
          add     ax,di
          mov     kod_adr, ax    ; adreso de unua klav-kodo por elsendi
          mov     kod_nom, 2     ; elsendu 2 kodojn
          jmp     k_visxu        ; forvisxu la punktokomon

; Modo estas iks-modo
k_x:      sal     di,1           ; indekso * 2 * 2
          sal     di,1
          mov     ax, offset x_tab  ; bazo de tabelo
          add     ax,di
          mov     kod_adr, ax    ; adreso de unua klav-kodo por elsendi
          mov     kod_nom, 2     ; elsendu 2 kodojn
          jmp     k_visxu        ; forvisxu la punktokomon

; Forvisxu la antauxan karaktron, kiu estas punktokomo.

k_visxu:  mov     ax,retropasxo
          mov     pk_flago,0     ; mallevu la punktokomoflagon

          jmp     eliro

k2:       mov     pk_flago,0     ; mallevu la punktokomoflagon
          cmp     al,';'         ; cxu legata karaktro estas punktokomo?
          jne     eliro          ; saltu se ne
          mov     pk_flago,1     ; levu la punktokomoflagon
          jmp     eliro

eliro:    popf
eliro2:   pop     es
          pop     ds
          pop     si
          pop     di
          pop     dx
          pop     cx
          pop     bx
          ret     2              ; reiru sen sxangxi flagojn

klavint   endp


;---------------------------------------------------------------------
; Post la halto de cxi tiu programo, cxio post "limo" malaperos.
; Cxio antaux postrestos.
;---------------------------------------------------------------------

limo:          

pretigu:
          push    ds
          push    es

		push    cs               ; metu kod-segmenton en ds
		pop     ds

;---------------------------------------------------------------------
; Kontrolu, cxu klavint' jam estas instalita.
;---------------------------------------------------------------------

          mov     ax,'kl'          ; mia kodo
          int     16h              ; klavara interromp-rutino
          cmp     ax,'KL'
          jne     p1               ; saltu se ne jam instalita

;---------------------------------------------------------------------
; Indiku, ke klavint' jam estas instalita.
;---------------------------------------------------------------------

          mov     dx, offset instalita
          mov     ah, 9
          int     21h                ; montru mesagxon

          pop     es
          pop     ds
          mov     ax, 4c00h     ; finu la programon
          int     21h

;---------------------------------------------------------------------
; Konservu malnovan klavaran interromp-rutinon.
;---------------------------------------------------------------------

p1:       mov     al, 16h          ; klavara interromp-numero en al
		mov     ah, 35h		; funkcio-numero por akiri adreson
		int     21h			; voku al DOS
		mov     word ptr malnova16[2], es     ; konservu segmenton
		mov     word ptr malnova16, bx        ; konservu distancon

;---------------------------------------------------------------------
; Enmetu novan klavaran interromp-rutinon.
;---------------------------------------------------------------------

		mov     dx, offset klavint     ; metu distancon en dx
		mov     al, 16h     ; interromp-numero en al
		mov     ah, 25h     ; enmetu interromp-rutinon en interromp-tabelon
		int     21h         ; voku al DOS

;---------------------------------------------------------------------
; Printu bonvenan mesagxon.
;---------------------------------------------------------------------

          mov     dx, offset mesagxo
          mov     ah, 9
          int     21h                ; montru mesagxon

;---------------------------------------------------------------------
; Haltu kaj postrestu en memoro.
;---------------------------------------------------------------------

          pop     es
          pop     ds

          ; Kalkulu la nombron da paragrafoj kiuj restos post halto
          
          mov     dx,(offset limo - offset komenco + 200h + 15) shr 4
          ; Pri tiu 200h: La programo ne funkcias kun nur 100h. Mi ne
          ; komprenas kial.
          mov     ax,3100h    ; haltu kaj postrestu
          int     21h
fino:

kodseg    ends
		end	komenco

                           