;---------------------------------------------------------------------
; VGA_LAT3  Cxi tiu programo sxangxas la literaron de VGA- kaj EGA- 
; grafikaj kartoj al la internacia normo ISO 8859-3, ankaux nomata
; Latin-3.
;---------------------------------------------------------------------
; Rajtoj:
; Oni rajtas uzi kaj sxangxi cxi tiun programon lauxplacxe, sed oni ne
; rajtas forigi cxi tiujn komentojn.
; VGA_LAT3 estas senpaga. Oni ne rajtas vendi gxin aux partojn de gxi.
; Oni rajtas disdoni la programon. Se vi disdonos sxangxitan version,
; bonvolu indiki, ke vi sxangxis gxin en la sekcio pri historio (sube).
;---------------------------------------------------------------------
; Kiel kontakti min:
;
; Retadreso:   cleve.lendon@canrem.com    (gxis junio 1994)
; Hejmadreso:  Klivo Lendon
;              608 Beresford Ave.
;              Toronto, Ontario
;              Canada
;              M6S 3C3
;
; Post junio 1994:
;
;              Klivo Lendon
;              1-15-2 Tama-machi
;              Fuchu-shi
;              Tokyo 183
;              Japan                 
;---------------------------------------------------------------------
; Historio
; Dato       Fusxinto            Komentoj 
; --------   ------------------  -------------------------------------
; 1993/12    Klivo               Unua versio.
;
;
;

kodseg    segment para
		assume	cs:kodseg, ds:kodseg
          org    100h

komencu:
        push  cs
        pop   ds            ; ds = cs
        push  cs
        pop   es            ; es = cs   necese?

        mov   ax, 3         ; sxangxu videomodon  (tekstmodo, mi kredas)
        int   10h           ; video-interromp-rutino

        mov   bp, offset karaktraro
        mov   bh, 16        ; 16 bajtoj po karaktro
        xor   bl, bl        ; karaktra bloko 0
        xor   dx, dx        ; unua karaktro #0
        mov   cx, 256       ; nombro da karaktroj por alsxuti
        mov   ax, 1110h     ; funkcio por alsxuti karaktraron (literaron)
        int   10h           ; video-interromp-rutino        

        ; Printu mesagxon.

        mov   dx, offset mesagxo
        mov   ah, 9
        int   21h           ; montru mesagxon

        ; Montru la karaktraron. (karaktraro? literaro? simbolaro? )

        xor   bl,bl         ; bl <- 0   unua aski-kodo
        xor   cl,cl         ; cl <- 0   nombrilo por linio de 64 kar
        mov   ah, 0eh       ; funkcio por sendi karaktron al la ekrano
l1:     mov   al,bl
        call  spaco         ; sxangxu gxenajn kodojn al spaco
        int   10h
        inc   bl            ; sekvanta kodo
        cmp   bl, 0ffh      ; cxu ni montris cxiujn karaktrojn?
        je    l3            ; saltu se jes
        inc   cl
        cmp   cl, 64        ; cxu ni montris tutan linion? (64)
        jne   l1            ; saltu se ne

        push  ax
        mov   dx, offset nova_linio
        mov   ah, 9
        int   21h           ; faru novan linion
        pop   ax
        xor   cl,cl         ; cl <- 0
        jmp   l1

l3:     mov   dx, offset sukceso
        mov   ah, 9
        int   21h           ; montru mesagxon

        mov   ax, 4c00h     ; finu la programon
        int   21h


; Sekvas mallonga rutino por sxangxi kelkajn gxenajn kodojn al spaco

spaco:   cmp  al,7      ; cxu sonorilo?
         je   s1        ; saltu se jes
         cmp  al,8      ; cxu retropasxo?
         je   s1
         cmp  al,10     ; cxu nova linio?
         je   s1
         cmp  al,13     ; cxu reiro?
         je   s1
         ret
s1:      mov  al,' '    ; sxangxu al spaco
         ret


;mesagxo     db      'VGA_ESP 1.0 --- Klivo 1994',10,13
;            db      'Esperanta Literaro por EGA/VGA',10,13,'$'

mesagxo     db      'VGA_LAT3 1.0 --- Klivo 1994',10,13
            db      'Latin-3 (ISO 8859-3) Literaro por EGA/VGA',10,13,'$'

sukceso     db      10,13
            db      'Se la lasta litero estas ^s, la programo sukcesis.'
            db      10,13,'$'

nova_linio  db      10,13,'$'

;---------------------------------------------------------------------
; Mi faris la sekvantan karaktraron per FONT MANIA de Rexxcom Systems
;---------------------------------------------------------------------

karaktraro  label  far
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 018H, 03CH, 03CH, 03CH, 018H
	DB	018H, 018H, 000H, 018H, 018H, 000H, 000H, 000H
	DB	000H, 000H, 063H, 063H, 063H, 022H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 06CH, 06CH, 0FEH, 06CH
	DB	06CH, 06CH, 0FEH, 06CH, 06CH, 000H, 000H, 000H
	DB	000H, 018H, 018H, 07CH, 0C6H, 0C2H, 0C0H, 07CH
	DB	006H, 086H, 0C6H, 07CH, 018H, 018H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 0C2H, 0C6H, 00CH
	DB	018H, 030H, 060H, 0C6H, 086H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 038H, 06CH, 06CH, 038H, 076H
	DB	0DCH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 030H, 030H, 030H, 060H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 00CH, 018H, 030H, 030H, 030H
	DB	030H, 030H, 030H, 018H, 00CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 030H, 018H, 00CH, 00CH, 00CH
	DB	00CH, 00CH, 00CH, 018H, 030H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 066H, 03CH
	DB	0FFH, 03CH, 066H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 018H, 018H
	DB	0FFH, 018H, 018H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 018H, 018H, 018H, 030H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	0FFH, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 018H, 018H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 002H, 006H, 00CH
	DB	018H, 030H, 060H, 0C0H, 080H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 07CH, 0C6H, 0C6H, 0CEH, 0D6H
	DB	0D6H, 0E6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 018H, 038H, 078H, 018H, 018H
	DB	018H, 018H, 018H, 018H, 07EH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 07CH, 0C6H, 006H, 00CH, 018H
	DB	030H, 060H, 0C0H, 0C6H, 0FEH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 07CH, 0C6H, 006H, 006H, 03CH
	DB	006H, 006H, 006H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 00CH, 01CH, 03CH, 06CH, 0CCH
	DB	0FEH, 00CH, 00CH, 00CH, 01EH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0FEH, 0C0H, 0C0H, 0C0H, 0FCH
	DB	00EH, 006H, 006H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 038H, 060H, 0C0H, 0C0H, 0FCH
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0FEH, 0C6H, 006H, 006H, 00CH
	DB	018H, 030H, 030H, 030H, 030H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 07CH, 0C6H, 0C6H, 0C6H, 07CH
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 07CH, 0C6H, 0C6H, 0C6H, 07EH
	DB	006H, 006H, 006H, 00CH, 078H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 018H, 018H, 000H
	DB	000H, 000H, 018H, 018H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 018H, 018H, 000H
	DB	000H, 000H, 018H, 018H, 030H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 006H, 00CH, 018H, 030H
	DB	060H, 030H, 018H, 00CH, 006H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 0FEH
	DB	000H, 000H, 0FEH, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 060H, 030H, 018H, 00CH
	DB	006H, 00CH, 018H, 030H, 060H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 07CH, 0C6H, 0C6H, 00CH, 018H
	DB	018H, 018H, 000H, 018H, 018H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 07CH, 0C6H, 0C6H, 0DEH
	DB	0DEH, 0DEH, 0DCH, 0C0H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 010H, 038H, 06CH, 0C6H, 0C6H
	DB	0FEH, 0C6H, 0C6H, 0C6H, 0C6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0FCH, 066H, 066H, 066H, 07CH
	DB	066H, 066H, 066H, 066H, 0FCH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 03CH, 066H, 0C2H, 0C0H, 0C0H
	DB	0C0H, 0C0H, 0C2H, 066H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0F8H, 06CH, 066H, 066H, 066H
	DB	066H, 066H, 066H, 06CH, 0F8H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0FEH, 066H, 062H, 068H, 078H
	DB	068H, 060H, 062H, 066H, 0FEH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0FEH, 066H, 062H, 068H, 078H
	DB	068H, 060H, 060H, 060H, 0F0H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 03CH, 066H, 0C2H, 0C0H, 0C0H
	DB	0DEH, 0C6H, 0C6H, 066H, 03AH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0C6H, 0C6H, 0C6H, 0C6H, 0FEH
	DB	0C6H, 0C6H, 0C6H, 0C6H, 0C6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 03CH, 018H, 018H, 018H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 01EH, 00CH, 00CH, 00CH, 00CH
	DB	00CH, 0CCH, 0CCH, 0CCH, 078H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0E6H, 066H, 06CH, 06CH, 078H
	DB	078H, 06CH, 066H, 066H, 0E6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0F0H, 060H, 060H, 060H, 060H
	DB	060H, 060H, 062H, 066H, 0FEH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0C3H, 0E7H, 0FFH, 0DBH, 0DBH
	DB	0C3H, 0C3H, 0C3H, 0C3H, 0C3H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0C6H, 0E6H, 0F6H, 0FEH, 0DEH
	DB	0CEH, 0C6H, 0C6H, 0C6H, 0C6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 038H, 06CH, 0C6H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 06CH, 038H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0FCH, 066H, 066H, 066H, 07CH
	DB	060H, 060H, 060H, 060H, 0F0H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 07CH, 0C6H, 0C6H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0D6H, 0DEH, 07CH, 00CH, 00EH, 000H
	DB	000H, 000H, 000H, 0FCH, 066H, 066H, 066H, 07CH
	DB	06CH, 066H, 066H, 066H, 0E6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 07CH, 0C6H, 0C6H, 060H, 038H
	DB	00CH, 006H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0FFH, 0DBH, 099H, 018H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0C6H, 0C6H, 0C6H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0C6H, 0C6H, 0C6H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 06CH, 038H, 010H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0C3H, 0C3H, 0C3H, 0C3H, 0C3H
	DB	0DBH, 0DBH, 0FFH, 066H, 066H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0C6H, 0C6H, 06CH, 06CH, 038H
	DB	038H, 06CH, 06CH, 0C6H, 0C6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 066H, 066H, 066H, 066H, 03CH
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0FFH, 0C3H, 083H, 006H, 00CH
	DB	018H, 030H, 061H, 0C3H, 0FFH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 03EH, 030H, 030H, 030H, 030H
	DB	030H, 030H, 030H, 030H, 03EH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 080H, 0C0H, 0E0H, 070H
	DB	038H, 01CH, 00EH, 006H, 002H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 03EH, 006H, 006H, 006H, 006H
	DB	006H, 006H, 006H, 006H, 03EH, 000H, 000H, 000H
	DB	000H, 010H, 038H, 06CH, 0C6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0FFH, 000H
	DB	000H, 030H, 030H, 018H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 078H, 00CH
	DB	07CH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0E0H, 060H, 060H, 078H, 06CH
	DB	066H, 066H, 066H, 066H, 0DCH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 07CH, 0C6H
	DB	0C0H, 0C0H, 0C0H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 01CH, 00CH, 00CH, 03CH, 06CH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 07CH, 0C6H
	DB	0FEH, 0C0H, 0C0H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 038H, 06CH, 064H, 060H, 0F0H
	DB	060H, 060H, 060H, 060H, 0F0H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 076H, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 07CH, 00CH, 0CCH, 078H
	DB	000H, 000H, 000H, 0E0H, 060H, 060H, 06CH, 076H
	DB	066H, 066H, 066H, 066H, 0E6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 018H, 018H, 000H, 038H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 006H, 006H, 000H, 00EH, 006H
	DB	006H, 006H, 006H, 006H, 006H, 066H, 066H, 03CH
	DB	000H, 000H, 000H, 0E0H, 060H, 060H, 066H, 06CH
	DB	078H, 078H, 06CH, 066H, 0E6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 038H, 018H, 018H, 018H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0E6H, 0FFH
	DB	0DBH, 0DBH, 0DBH, 0DBH, 0DBH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0DCH, 066H
	DB	066H, 066H, 066H, 066H, 066H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 07CH, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0DCH, 066H
	DB	066H, 066H, 066H, 066H, 07CH, 060H, 060H, 0F0H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 076H, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 07CH, 00CH, 00CH, 01EH
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0DCH, 076H
	DB	062H, 060H, 060H, 060H, 0F0H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 07CH, 0C6H
	DB	060H, 038H, 00CH, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 010H, 030H, 030H, 0FCH, 030H
	DB	030H, 030H, 030H, 036H, 01CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0CCH, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 066H, 066H
	DB	066H, 066H, 066H, 03CH, 018H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0C3H, 0C3H
	DB	0C3H, 0DBH, 0DBH, 0FFH, 066H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0C6H, 06CH
	DB	038H, 038H, 038H, 06CH, 0C6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07EH, 006H, 00CH, 0F8H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0FEH, 0CCH
	DB	018H, 030H, 060H, 0C6H, 0FEH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 00EH, 018H, 018H, 018H, 070H
	DB	018H, 018H, 018H, 018H, 00EH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 018H, 018H, 018H, 018H, 000H
	DB	018H, 018H, 018H, 018H, 018H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 070H, 018H, 018H, 018H, 00EH
	DB	018H, 018H, 018H, 018H, 070H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 076H, 0DCH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 066H, 0FFH, 066H, 066H, 07EH
	DB	066H, 066H, 066H, 066H, 066H, 000H, 000H, 000H
	DB	000H, 066H, 03CH, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 038H, 06CH, 064H, 060H, 0F0H, 060H
	DB	060H, 060H, 060H, 0E6H, 0FCH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0C3H, 066H, 07EH, 066H, 066H
	DB	07EH, 066H, 0C3H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	010H, 038H, 06CH, 000H, 0C6H, 0C6H, 0C6H, 0FEH
	DB	0C6H, 0C6H, 0C6H, 0C6H, 0C6H, 000H, 000H, 000H
	DB	000H, 07CH, 0C6H, 060H, 038H, 06CH, 0C6H, 0C6H
	DB	06CH, 038H, 00CH, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 066H, 066H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 018H, 018H, 000H, 03CH, 018H, 018H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 07CH, 0C6H, 0C6H, 060H, 038H
	DB	00CH, 006H, 0C6H, 0C6H, 07CH, 018H, 00CH, 038H
	DB	000H, 066H, 03CH, 000H, 03CH, 066H, 0C2H, 0C0H
	DB	0DEH, 0C6H, 0C6H, 066H, 03AH, 000H, 000H, 000H
	DB	010H, 038H, 06CH, 000H, 01EH, 00CH, 00CH, 00CH
	DB	00CH, 0CCH, 0CCH, 0CCH, 078H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	0FFH, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 018H, 018H, 000H, 0FFH, 0C3H, 086H, 00CH
	DB	018H, 030H, 061H, 0C3H, 0FFH, 000H, 000H, 000H
	DB	000H, 038H, 06CH, 038H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0E0H, 060H, 0FEH, 060H, 06CH
	DB	076H, 066H, 066H, 066H, 0E6H, 000H, 000H, 000H
	DB	000H, 078H, 0CCH, 018H, 030H, 060H, 0FCH, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 078H, 0CCH, 018H, 018H, 0CCH, 078H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	00CH, 018H, 030H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0FEH, 0DBH, 0C0H, 0C0H, 080H
	DB	010H, 038H, 06CH, 000H, 0E0H, 060H, 060H, 06CH
	DB	076H, 066H, 066H, 066H, 0E6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 018H
	DB	018H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 030H, 018H, 00CH, 038H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 038H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 07CH, 0C6H
	DB	060H, 038H, 00CH, 0C6H, 07CH, 018H, 00CH, 038H
	DB	000H, 000H, 000H, 0CCH, 078H, 000H, 076H, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 07CH, 00CH, 0CCH, 078H
	DB	000H, 000H, 008H, 01CH, 036H, 000H, 00EH, 006H
	DB	006H, 006H, 006H, 006H, 006H, 066H, 066H, 03CH
	DB	000H, 000H, 0C0H, 0C0H, 0C2H, 0C6H, 0CCH, 018H
	DB	030H, 060H, 0CEH, 093H, 006H, 00CH, 01FH, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 030H, 030H, 000H, 0FEH, 0CCH
	DB	018H, 030H, 060H, 0C6H, 0FEH, 000H, 000H, 000H
	DB	030H, 018H, 00CH, 000H, 010H, 038H, 06CH, 0C6H
	DB	0C6H, 0FEH, 0C6H, 0C6H, 0C6H, 000H, 000H, 000H
	DB	018H, 030H, 060H, 000H, 010H, 038H, 06CH, 0C6H
	DB	0C6H, 0FEH, 0C6H, 0C6H, 0C6H, 000H, 000H, 000H
	DB	010H, 038H, 06CH, 000H, 010H, 038H, 06CH, 0C6H
	DB	0C6H, 0FEH, 0C6H, 0C6H, 0C6H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 06CH, 06CH, 000H, 010H, 038H, 06CH, 0C6H
	DB	0C6H, 0FEH, 0C6H, 0C6H, 0C6H, 000H, 000H, 000H
	DB	000H, 018H, 018H, 000H, 03CH, 066H, 0C2H, 0C0H
	DB	0C0H, 0C0H, 0C2H, 066H, 03CH, 000H, 000H, 000H
	DB	018H, 03CH, 066H, 000H, 03CH, 066H, 0C2H, 0C0H
	DB	0C0H, 0C0H, 0C2H, 066H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 03CH, 066H, 0C2H, 0C0H
	DB	0C0H, 0C0H, 0C2H, 066H, 03CH, 018H, 00CH, 038H
	DB	060H, 030H, 018H, 000H, 0FEH, 066H, 062H, 068H
	DB	078H, 068H, 062H, 066H, 0FEH, 000H, 000H, 000H
	DB	00CH, 018H, 030H, 000H, 0FEH, 066H, 062H, 068H
	DB	078H, 068H, 062H, 066H, 0FEH, 000H, 000H, 000H
	DB	010H, 038H, 06CH, 000H, 0FEH, 066H, 062H, 068H
	DB	078H, 068H, 062H, 066H, 0FEH, 000H, 000H, 000H
	DB	000H, 06CH, 06CH, 000H, 0FEH, 066H, 062H, 068H
	DB	078H, 068H, 062H, 066H, 0FEH, 000H, 000H, 000H
	DB	030H, 018H, 00CH, 000H, 03CH, 018H, 018H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	00CH, 018H, 030H, 000H, 03CH, 018H, 018H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	018H, 03CH, 066H, 000H, 03CH, 018H, 018H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 066H, 066H, 000H, 03CH, 018H, 018H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 076H, 0DCH, 000H, 0C6H, 0E6H, 0F6H, 0FEH
	DB	0DEH, 0CEH, 0C6H, 0C6H, 0C6H, 000H, 000H, 000H
	DB	060H, 030H, 018H, 000H, 038H, 06CH, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 06CH, 038H, 000H, 000H, 000H
	DB	00CH, 018H, 030H, 000H, 038H, 06CH, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 06CH, 038H, 000H, 000H, 000H
	DB	010H, 038H, 06CH, 000H, 038H, 06CH, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 06CH, 038H, 000H, 000H, 000H
	DB	000H, 018H, 018H, 000H, 03CH, 066H, 0C2H, 0C0H
	DB	0DEH, 0C6H, 0C6H, 066H, 03AH, 000H, 000H, 000H
	DB	000H, 06CH, 06CH, 000H, 038H, 06CH, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 06CH, 038H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 0C6H, 06CH
	DB	038H, 06CH, 0C6H, 000H, 000H, 000H, 000H, 000H
	DB	018H, 03CH, 066H, 000H, 03CH, 066H, 0C2H, 0C0H
	DB	0DEH, 0C6H, 0C6H, 066H, 03AH, 000H, 000H, 000H
	DB	060H, 030H, 018H, 000H, 0C6H, 0C6H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	00CH, 018H, 030H, 000H, 0C6H, 0C6H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	010H, 038H, 06CH, 000H, 0C6H, 0C6H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 0C6H, 0C6H, 000H, 0C6H, 0C6H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 0C6H, 07CH, 000H, 0C6H, 0C6H, 0C6H, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	010H, 038H, 06CH, 000H, 07CH, 0C6H, 0C0H, 060H
	DB	038H, 00CH, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 078H, 0CCH, 0CCH
	DB	0F8H, 0CCH, 0C6H, 0C6H, 0FCH, 0C0H, 0C0H, 080H
	DB	000H, 000H, 060H, 030H, 018H, 000H, 078H, 00CH
	DB	07CH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 018H, 030H, 060H, 000H, 078H, 00CH
	DB	07CH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 010H, 038H, 06CH, 000H, 078H, 00CH
	DB	07CH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0CCH, 0CCH, 000H, 078H, 00CH
	DB	07CH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 018H, 018H, 000H, 07CH, 0C6H
	DB	0C0H, 0C0H, 0C0H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 010H, 038H, 06CH, 000H, 07CH, 0C6H
	DB	0C0H, 0C0H, 0C0H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 07CH, 0C6H
	DB	0C0H, 0C0H, 0C0H, 0C6H, 07CH, 018H, 00CH, 038H
	DB	000H, 000H, 060H, 030H, 018H, 000H, 07CH, 0C6H
	DB	0FEH, 0C0H, 0C0H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 00CH, 018H, 030H, 000H, 07CH, 0C6H
	DB	0FEH, 0C0H, 0C0H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 010H, 038H, 06CH, 000H, 07CH, 0C6H
	DB	0FEH, 0C0H, 0C0H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0C6H, 0C6H, 000H, 07CH, 0C6H
	DB	0FEH, 0C0H, 0C0H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 060H, 030H, 018H, 000H, 038H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 00CH, 018H, 030H, 000H, 038H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 018H, 03CH, 066H, 000H, 038H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 066H, 066H, 000H, 038H, 018H
	DB	018H, 018H, 018H, 018H, 03CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 076H, 0DCH, 000H, 0DCH, 066H
	DB	066H, 066H, 066H, 066H, 066H, 000H, 000H, 000H
	DB	000H, 000H, 060H, 030H, 018H, 000H, 07CH, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 018H, 030H, 060H, 000H, 07CH, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 010H, 038H, 06CH, 000H, 07CH, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 030H, 030H, 000H, 076H, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 07CH, 00CH, 0CCH, 078H
	DB	000H, 000H, 000H, 0C6H, 0C6H, 000H, 07CH, 0C6H
	DB	0C6H, 0C6H, 0C6H, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 018H, 018H, 000H
	DB	0FFH, 000H, 018H, 018H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 030H, 078H, 0CCH, 000H, 076H, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 07CH, 00CH, 0CCH, 078H
	DB	000H, 000H, 060H, 030H, 018H, 000H, 0CCH, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 018H, 030H, 060H, 000H, 0CCH, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 030H, 078H, 0CCH, 000H, 0CCH, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0CCH, 0CCH, 000H, 0CCH, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 0CCH, 078H, 000H, 0CCH, 0CCH
	DB	0CCH, 0CCH, 0CCH, 0CCH, 076H, 000H, 000H, 000H
	DB	000H, 000H, 010H, 038H, 06CH, 000H, 07CH, 0C6H
	DB	060H, 038H, 00CH, 0C6H, 07CH, 000H, 000H, 000H
	DB	000H, 018H, 018H, 000H, 000H, 000H, 000H, 000H
	DB	000H, 000H, 000H, 000H, 000H, 000H, 000H, 000H

kodseg  ends

        end   komencu
                                                                                             