; ----------------- hw2.lisp --------------------------------------------
; 
; cs674 Assignment #2                             Yi-Chen Emily Hsu
;                                                 Jui-Yuan Fred Hsu 
;                                                 Jui-Chieh Richard Hsu
; notes:
; - by default, in lexicon definition, features are by default '-'
;   i.e. (irreg-past -) need not be declared
;   but  (irreg-past +) need be declared
; 
; - feature (var) is always created for each Lexical entry 
;   when it is instantiated
; - we can make use of this thing, by declaring (in grammar rules)
;   var as head feature for grammars
;   ( (n) -> (head (n)) (+s) )    <- left side will have same 'var'
;
; (sem dog)  <- simple semantics.  return dog as feature value
;               whenever a value appears, we can use ?v variable to substitute
;
; (sem (NAME ?v1 ?v2)) <- (NAME ?v1 ?v2) is treated like a single value
;      ------------- this is a LIST, not predicate (NAME is JUST a word)
;
; (sem (UNSCOPED word1 word2)) <- <word1 word2> seems like concatenate
;                                 (UNSCOPED is unspecified category)
;       the whole list will be returned as one value
;
; ---- list
; ((xx (sem (v (vform pres))) ) -xx-> (time ) )
; XX924:<XX ((SEM (V (VFORM PRES))) (1 TIME923))> from 0 to 1
;
; ---- constituent as feature value
;        --> in fact, (% v..) is a 'constituent', just like left hand 
;            side of rule.  e.g. (np (feature value)) 
; ((xx (sem (% v (vform pres))) ) -xx-> (time ) )
; XX1110:<XX ((SEM <V ((VFORM PRES))>) (1 TIME1109))> from 0 to 1
;
;    ((xx (sem (% n (agr ?a))) ) -xx-> (n (agr ?a)) )
;    ((yy (sem ?s)) -yy-> (xx (sem ?s))) 
; YY1871:<YY ((SEM <N ((AGR 3S))>) (1 XX1863))> from 0 to 1
; XX1863:<XX ((SEM <N ((AGR 3S))>) (1 N1862))> from 0 to 1
;
;    ((xx (sem (n (agr ?a))) ) -xx-> (n (agr ?a)) )
;    ((yy (sem ?s)) -yy-> (xx (sem ?s))) 
;YY2060:<YY ((SEM (N (AGR 3S))) (1 XX2052))> from 0 to 1
;XX2052:<XX ((SEM (N (AGR 3S))) (1 N2051))> from 0 to 1
;
; ----- modified parser
;
; perform some LISP operation on feature values/variables, and return 
;  a single value as result
;
; format:   (feature (^  lisp-expression-to-be-evaluated))  
; all variables in the expression will be 'bound' first, and then finally
;  the lisp expression is evaluated
;
;ex:  (sem (^ (append (quote (agr ?a)) (quote(root ?r))) ))
;  
;  result:  (SEM (AGR 3S ROOT DOG-N1))
;
;ex:  (sem (^ (quote ?lex))) 



; -------------------------------------- loading parsers --------------

(in-package :user)
(Format t "~%~%---------------- Loading SuperBrain ------ stand by ... ~%~%")

(load "../allen/loadFunction") 

(loadf "LoadParser")

(defun p (list) (bu-parse list))

(enableSem)                              ; MUST do this for (sem..) to work

(defun makestr (i)  (cond ((symbolp i) (string i))
                          ((stringp i) i)
                          ((numberp i) (princ-to-string i))
                          ( t i ) ) )

(defun join (str1 str2) (concatenate 'string (makestr str1) (makestr str2)))
(defun join3 (str1 str2 str3) (concatenate 'string (makestr str1) 
                              (makestr str2) (makestr str3) ))
                         
(defun joinS (str1 str2) (concatenate 'string 
                          (makestr str1) " " (makestr str2)))
                         
(defun joinS3 (str1 str2 str3) (concatenate 'string 
                      (makestr str1) " " (makestr str2) " " (makestr str3)))

(defun joinS4 (str1 str2 str3 str4) (concatenate 'string 
    (makestr str1) " " (makestr str2) " " (makestr str3) " " (makestr str4) ))


; -------------------------------- declare lexical categories ----------

(setq *lexical-cats* '(n v adj2 art aux pro qdet pp-wrd name2 to place conj 
                       prep incomplete that-subj num time adv2))

; ----------------------------- general grammars/lexicon -----------------

(setq *general-forms*  
 '(cat
    
    ((time (root ?r) (num-form ?n) (sem-done +) (agr 3s)
           (sem (^ (joinS (quote ?n) 
                          (quote ?lex2)))) )
       -time-1->                                           ; day of month
        (num (num-form ?n)) 
        (time (time-form month) (root ?r) (lex ?lex2) ))
        
  )       
) ; --- end *noun-forms* 

(setq *general-lexicon*
'(
  (a   (art (root A1) (agr 3s) (sem "A")))
  (the (art (root THE1) (agr (? a 3s 3p)) (sem "THE") ))

  (+s   (+S))
  (+ed  (+ED))
  (+en  (+EN))
  (+ing (+ING))
  (+al  (+AL))
  (+ly  (+LY))

  (to (to  (root to-1) (vform inf)))

  (of   (of (root of-1)) )
  
  (when  (when-conj (root when-conj-1) ) )
  (that  (that-subj (root that-subj-1) ) )
  
  ($comma$  ($comma$))
  ($period$ ($period$))
  ($semi$   ($semis$))

  (and (conj (root and-conj-1) (agr 3p) (always-plural +) (sem "and") ))
  (or  (conj (root or--conj-1) (agr ?a) (sem "or") ))

  (four (num (num-form 4) ))
  (3    (num (num-form 3) ))
  (5    (num (num-form 5) ))

))

; --------------------- grammar rules/lexicon for VERBS ---------------------

(setq *verb-forms*       
 
'( (headfeatures
     (v-aux  root subcat Event vform agr)
     (v      root subcat prep-compl Event)      ; remember to synchronize with
     (verb   root subcat vform agr passive)     ; past tense below
   )

  ((v-aux (aux-v-be +))   -auxv-1-> (head (v (aux-v-be +)))         )
  ((v-aux (aux-v-be +))   -auxv-2-> (head (v (aux-v-be +)))   (adv) )
  ((v-aux (aux-v-have +)) -auxv-3-> (head (v (aux-v-have +)))       )
  ((v-aux (aux-v-have +)) -auxv-4-> (head (v (aux-v-have +))) (adv) )
  
  ((v (vform pres) (agr 3s)) -v-1->                    ; 3rd sing present
                                                       ; regular
     (head (v (vform bare) (irreg-pres -))) (+s))      ; [ root +s ] 
   
  ((v (vform pres) (agr (? a 1s 2s 1p 2p 3p))) -v-2->  ; rest,  present
                                                       ; regular 
     (head (v (vform bare) (irreg-pres -))))           ; [ root ]
   
  ((v (vform past) (agr (? a 1s 2s 3s 1p 2p 3p)))      ; all, past
   -v-3->                                              ; regular
   (head (v (vform bare) (irreg-past -))) (+ed))       ; [ root +ed ]
  
  ((v (vform pastprt)) -v-4->                          ; all, past particle
                                                       ; regular 
   (head (v (vform bare) (en-pastprt -))) (+ed))       ; [ root +ed ]
       
  ((v (vform pastprt)) -v-5->                          ; all, 'en'-ended 
                                                       ; past particles
   (head (v (vform bare) (en-pastprt +))) (+en))       ; [ root +en ]
   
  ((v (vform ing)) -v-6->                              ; all, present particle
                                                       ; [ root +ing ]
   (head (v (vform bare))) (+ing))

  ((v (vform ?v) (progress +) (agr ?a)) -v-7->                     ; progress
  
      (v-aux (aux-v-be +) (agr ?a) (vform (? v pres past)))
      (head (v (vform ing))) )
  
  ((v (vform ?v) (perfect +) (agr ?a)) -v-8->                       ; perfect
  
      (v-aux (aux-v-have +) (agr ?a) (vform (? v pres past)))
      (head (v (vform pastprt))) )
      
      
  ((verb (sem (EVENT ?ev))) 
   -v-9->                                ; final verb form (no prepositions)
     (head (v (Event ?ev) 
              (prep-compl -) )) )
  
  ((verb (sem (EVENT ?ev)))
   -v-10->                                      ; verbs that need prepositions
     (head (v (Event ?ev) (prep-compl ?pc)))
     (prep (lex ?pc)) ) 
      
)) ; --- end *verb-forms* 


(setq *passive-forms*             ; ------------ passive forms --------------

'( (headfeatures

     (v root subcat prep-compl Event)   
   )

  ((v (passive +) (vform ?v) (agr ?a)) -pass-v-1->             ; simple passive 
                                                               ; A killed B
      (v-aux (aux-v-be +) (agr ?a) (vform (? v pres past)))    ; B is killed by
      (head (v (vform pastprt))) )
  
  ((v (passive +) (progress +) (vform ?v) (agr ?a)) -pass-v-2->  ; progressive 
                                                                 ; A is killing
      (v-aux (aux-v-be +) (agr ?a) (vform (? v pres past)))      ; B is being k
      (v (aux-v-be +) (vform ing)) (head (v (vform pastprt))) )
  
  ((v (passive +) (perfect +) (vform ?v) (agr ?a)) -pass-v-3->   ; perfect
                                                                 ; A has killed
      (v-aux (aux-v-have +) (agr ?a) (vform (? v pres past)))    ; B has been k
      (v (aux-v-be +) (vform pastprt)) (head (v (vform pastprt))) )

)) ; ----- end *passive-forms* 


(setq *verb-lexicon*
'(
  (be    (v (root BE-v1) (vform bare) (subcat (? s _adjp _np))    (aux-v-be +)
                                      (irreg-pres +) (irreg-past +) 
                                      (Event equality) ))
  (am    (v (root BE-v1) (vform pres) (subcat (? s _adjp _np))    (aux-v-be +)
                                      (agr 1s) (Event equality) ))
  (is    (v (root BE-v1) (vform pres) (subcat (? s _adjp _np))    (aux-v-be +)
                                      (agr 3s) (Event equality) ))
  (are   (v (root BE-v1) (vform pres) (subcat (? s _adjp _np))    (aux-v-be +)
                                      (agr (? a 2s 1p 2p 3p)) (Event equality)))
  (was   (v (root BE-v1) (vform past) (subcat (? s _adjp _np))    (aux-v-be +)
                                      (agr (? a 1s 3s)) (Event equality) ))
  (were  (v (root BE-v1) (vform past) (subcat (? s _adjp _np))    (aux-v-be +)
                                      (agr (? a 2s 1p 2p 3p)) (Event equality)))
  (being (v (root BE-v1) (vform ing)     (subcat (? s _adjp _np)) (aux-v-be +) 
                                         (agr (? a 1s 2s 3s 1p 2p 3p)) 
                                         (Event equality) )) 
  (been  (v (root BE-v1) (vform pastprt) (subcat (? s _adjp _np)) (aux-v-be +)
                                         (agr (? a 1s 2s 3s 1p 2p 3p)) 
                                         (Event equality) )) 
  
  (have  (v (root HAVE-v1)  (vform bare) (irreg-pres +) (irreg-past +) 
                            (aux-v-have +) (Event possession) ))
  (have  (v (root HAVE-v1)  (vform pres) (agr (? a 1s 2s 1p 2p 3p)) 
                            (aux-v-have +) (Event possession) ))
  (has   (v (root HAVE-v1)  (vform pres)   (agr 3s) (aux-v-have +) 
                            (Event possession) ))
  (had   (v (root HAVE-v1)  (vform past)   (agr ?a) (aux-v-have +)  
                            (Event possession) ))
  (had   (v (root HAVE-v1)  (vform pastprt)(agr ?a) (aux-v-have +)  
                            (Event possession) ))
  (having (v (root HAVE-v1) (vform ing)    (agr ?a) (aux-v-have +)  
                            (Event possession) ))

  (see  (v (root SEE-v1) (vform bare)    (subcat _np) 
                         (irreg-past +)  (en-pastprt +) (Event seeing) ))
  (saw  (v (root SEE-v1) (vform past)    (subcat _np)   (Event seeing) ))
  (seen (v (root SEE-v1) (vform pastprt) (subcat _np)   (Event seeing) ))
  (seeing (v (root SEE-v1) (vform ing)   (subcat _np)   (Event seeing) ))

  (want (v (root WANT-v1) (vform bare) (subcat (? s _np _vp-inf _np_vp-inf)) 
        (Event desiring) ))

  (cry   (v (root CRY-v1) (vform bare) (subcat _none) (Event crying) ))

  (kill     (v (root kill-v1)     (vform bare) (subcat (? s _np )) 
                                  (Event murder) ))
  (murder   (v (root murder-v1)   (vform bare) (subcat (? s _np )) 
                                  (Event murder) ))
  (travel   (v (root travel-v1)   (vform bare) (subcat (? s _np _none )) 
                                  (Event traveling) ))
  (detonate (v (root detonate-v1) (vform bare) (subcat (? s _np _none )) 
                                  (Event detonate) ))
  (kidnap   (v (root kidnap-v1)   (vform bare) (subcat (? s _np )) 
                                  (Event kidnapping) ))
  
  (find   (v (root find-v1) (vform bare) (subcat (? s _np _np_adjp))
                            (Event finding) (irreg-past +) ))
  (found  (v (root find-v1) (vform (? v past pastprt)) 
                            (subcat (? s _np _np_adjp))
                            (Event finding) ))
  (die    (v (root die-v1)  (vform bare)    (subcat (? s _none))
                            (Event dying) ))
  (dead   (v (root die-v1)  (vform pastprt) (subcat (? s _none))
                            (Event dying) ))
  (blow   (v (root blow-v1) (vform bare)    (subcat (? s _np))
                            (Event blowing) ))
  (blown  (v (root blow-v1) (vform pastprt) (subcat (? s _np))
                            (Event blowing) ))

  (blow   (v (root blow-v2) (vform bare) (subcat (? s _np))
                            (Event Explosion) (prep-compl up) ))
  (blown  (v (root blow-v2) (vform pastprt) (subcat (? s _np))
                            (Event Explosion) (prep-compl up) ))

)) ; ----- end *verb-lexicon* 
  

; --------------------- grammar rules/lexicon for Nouns ----------------------

(setq *noun-forms*          
 
'( (headfeatures
     (noun2 root allow-al-adj possessive simple irreg-pl lex) 
     (noun  root allow-al-adj possessive simple irreg-pl lex agr type) 
     (name  root agr)
   )                                             

  ((noun2 (agr 3p) (type ?t) (sem-done +)
          (sem (^ (join (quote ?lex) "+S"))) )                ; noun plural
     -n-1->                                                   ; [ root +s ]
     (head (noun2 (agr 3s) (irreg-pl -) (type ?t) (lex ?lex)))
     (+s))

  ((noun2 (agr ?a) (type (? t obj place))) -n-2->            ; normal obj nouns
      (head (n (agr ?a) (type -))) )

  ((noun2 (agr ?a) (type pro)) -n-3->                        ; noun = pronoun
      (head (pro (simple +) (agr ?a))))

  ((noun2 (agr ?a) (type place)) -n-5->                      ; noun = place
      (head (place (agr ?a))))
  
  ((noun2 (agr 3s) (type time)) -n-6-> 
     (head (time (sem-done -))))                             ; noun = time  
     
  ((noun2 (agr 3s) (type time) (sem ?s) (sem-done +)) -n-7->
     (head (time (sem-done +) (sem ?s))) )

  ((noun (sem (^ (string (quote ?lex))))) -n-8->             ; add sem to it
      (head (noun2 (lex ?lex) (sem-done -))) )
      
  ((noun (sem ?s)) -n-9-> (head (noun2 (sem-done +) (sem ?s))) )   ; has sem
  
  ((name (type name) (sem (^ (string (quote ?lex))))) 
    -n-10->                                                  ; special - name
      (head (name2 (lex ?lex))) )

)) ; --- end *noun-forms* 


(setq *noun-lexicon*
'(  
  (dog    (n (root DOG-n1)  (agr 3s) ))
  (fish   (n (root FISH-n1) (agr (? a 3s 3p)) (IRREG-PL +) ))
  (man    (n (root MAN-n1)  (agr 3s) (IRREG-PL +) ))
  (men    (n (root MAN-n1)  (agr 3p) ))

  (mayor       (n (root -n1)           (agr 3s) ))
  (department  (n (root department-n1) (agr 3s) (allow-al-adj +) ))
  (guerrilla   (n (root guerrila-n1)   (agr 3s) ))
  (authorities (n (root authority-n1)  (agr 3p) ))
  (column      (n (root column-n1)     (agr 3s) ))
  (son         (n (root son-n1)        (agr 3s) ))
  (government  (n (root government-n1) (agr 3s) (allow-al-adj +) ))
  (secretary   (n (root secretary-n1)  (agr 3s) ))
  (bodyguard   (n (root bodyguard-n1)  (agr 3s) ))
  (group       (n (root group-n1)      (agr (? a 3s 3p)) ))
  (drive       (n (root drive-n1)      (agr 3s) ))
  (vehicle     (n (root vehicle-n1)    (agr 3s) ))
  (area        (n (root area-n1)       (agr 3s) ))
  (charge      (n (root charge-n1)     (agr 3s) ))
  (highway     (n (root highway-n1)    (agr 3s) ))

  (he     (pro  (root HE-n1)   (agr 3s) (simple +)))
  (they   (pro  (root they-n1) (agr 3p) (simple +)))
  
  (his    (pro  (root he-n1)   (agr 3s) (possessive +)))
  (their  (pro  (root they-n1) (agr 3p) (possessive +)))

  (january  (time (root january-time-1) (time-form month)))
  (today    (time (root today-time-1) ))
  (day      (time (root day-time-1)   ))

  (ricardo     (name2 (root ricardo-n1)    (agr 3s) ))
  (alfonso     (name2 (root alfonso-n1)    (agr 3s) ))
  (castellar   (name2 (root castellar-n1)  (agr 3s) ))
  (carlos      (name2 (root carlos-n1)     (agr 3s) ))
  (julio       (name2 (root julio-n1)      (agr 3s) ))
  (torrado     (name2 (root torrado-n1)    (agr 3s) ))
  (william     (name2 (root william-n1)    (agr 3s) ))
  (gustavo     (name2 (root gustavo-n1)    (agr 3s) ))
  (jacome      (name2 (root jacome-n1)     (agr 3s) ))
  (quintero    (name2 (root quintero-n1)   (agr 3s) ))
  (jairo       (name2 (root jairo-n1)      (agr 3s) ))
  (ortega      (name2 (root ortega-n1)     (agr 3s) ))
  (cucuta      (name2 (root cucuta-n1)     (agr 3s) ))
  (campanario  (name2 (root campanario-n1) (agr 3s) ))

  (achi       (place (root achi-n1)      (agr 3s) ))
  (bolivar    (place (root bolivar-n1)   (agr 3s) ))
  (eln        (place (root eln-n1)       (agr 3s) (allow-adj +) ))
  (colombia   (place (root colombia-n1)  (agr 3s) ))
  (abrego     (place (root abrego-n1)    (agr 3s) ))
  (santander  (place (root santander)    (agr 3s) ))

))

; ----------------------- rules/lexicon for ADJECTIVES --------------------

(setq *adj-forms*          
 
'( (headfeatures
     (adj2  root lex )
     (adj   root subcat allow-ly-adv )
   )
  
  ((adj2 (allow-ly-adv +) (sem-done +)
         (sem (^ (join ?s "+AL"))) )                ; adj=n+al
     -adj-3->                                             
     (head (noun (allow-al-adj +) (sem ?s)))
     (+al))
      
  ((adj2 (agr ?a)) -adj-4->                         ; adj=poss. pron
      (head (pro (possessive +) (agr ?a))) )
      
  ((adj2 (agr ?a)) -adj-5->                         ; place as adj
      (head (place (allow-adj +) (agr ?a))) )

  ((adj (sem (^ (makestr (quote ?lex))))) -adj-6-> 
        (head (adj2 (lex ?lex) (sem-done -))) )     ; add semantics 

  ((adj (sem ?s)) -adj-7-> 
       (head (adj2 (sem-done +) (sem ?s))) )        ; already has sem

  ((adjp (sem ?s)) -adj-11-> (head (adj (sem ?s))) )
  
  ((adjp (sem (?s ?semvp))) 
    -adj-12-> 
         (head (adj (subcat _vp-inf) (sem ?s))) 
         (vp (vform inf) (sem ?semvp)) )
  
 )
)  ; ----- adj-forms 


(setq *adj-lexicon*
'(  
  (happy  (adj2 (root HAPPY-a1) (subcat _vp-inf) ))

  (4-wheel      (adj2 (root 4-wheel-a1) ))
  (another      (adj2 (root another-a1) ))
  (last         (adj2 (root last-a1) ))
  (second       (adj2 (root second-a1) ))
  (northern     (adj2 (root nothern-a1) ))
  (northeastern (adj2 (root northeastern-a1) ))
  (rural        (adj2 (root rural-a1) ))
  (known        (adj2 (root known-a1) ))
  (explosive    (adj2 (root explosive-a1) ))
  (dead         (adj2 (root dead-a1) ))
  (stupid       (adj2 (root stupid-a1) ))

  (apparent (adj2 (root apparent-a1) (allow-ly-adv +) ))

  (four (adj2 (root four-a1) ))
  (3    (adj2 (root three-a1) ))
))


; ----------------------- rules/lexicon for ADVERBS --------------------

(setq *adv-forms*          
 
'( (headfeatures
     (adv2  root lex )
     (adv   root )
   )

  ((adv2 (sem-done +) (sem (^ (join ?s "+LY"))) )        ; adv=adj + ly
     -adv-1->                                             
     (head (adj (allow-ly-adv +) (sem ?s)))
     (+ly))

  ((adv (sem (^ (string (quote ?lex))))) -adv-2-> 
        (head (adv2 (lex ?lex) (sem-done -))) )          ; add semantics 

  ((adv (sem ?s)) -adv-3-> 
       (head (adv2 (sem-done +) (sem ?s))) )             ; already has sem

 ) 
)  ; ----- adv-forms 

(setq *adv-lexicon*
'(  
  (also       (adv2 (root also-av1)  ))
  (today      (adv2 (root today-av1) ))
))


; ----------------------- rules/lexicon for prepositions --------------------

(setq *prep-forms*          
 
'(cat 
  ((pp (pform ?p) (sem (?semp ?s)) 
       (last-agr ?a) (last-sem ?s))
    -prep-1->                                                ; pp = prep + np
       (prep (pform ?p) (type ?t) (sem ?semp)) 
       (np (type ?t) (sem ?s) (agr ?a)) )

  ((pp (pform adv) (sem (ADV ?s))) 
    -prep-2->                                                ; pp = adv 
      (adv (sem ?s)) )         

  ((prep (root according-prep-1) (pform info-source) 
         (sem SOURCE) (type (? t obj pro name)) )
    -gen-1->                                                 ; according to
     (incomplete (root according-incmp-1)) 
     (to) )

 ) 
)  ; ----- prep-forms 

(setq *prep-lexicon*
'(  

  (to   (prep (pform to_loc) (type place)  (sem DESTINATION) ) )
  (in   (prep (pform in_loc) (type place)  (sem LOCATION)    ) )
  (in   (prep (pform in_time)(type time)   (sem TIME)        ) )
  (on   (prep (pform on_loc) (type place)  (sem LOCATION)    ) )
  (on   (prep (pform on_time)(type time)   (sem TIME)        ) )
  
  (by   (prep (pform by_obj) (type obj)    (sem CAUSED_BY)   ) )
  (by   (prep (pform by_person) 
              (type (? p pro name))        (sem CAUSED_BY)   ) )
  
  (as   (prep (pform as) (type ?t)         (sem AS)          ) )
  (up   (prep (pform up) (type ?t)         (sem UP)          ) )

  (between (prep (pform betwen_loc) (type place) 
                 (sem INTERMEDIATE-SPACE) ))

  (according (incomplete (root according-incmp-1) ) )

))


; --------------------- grammar rules/lexicon for NOUN Phrases ----------------

(setq *np-forms*          
 
'( (headfeatures
     (np0    agr type sem)
     (n-np   agr type)
     (n-np2- agr type sem)
     (adj-n  agr type)
     (pers   agr type)
     (persx  agr type)
     (np1-   agr type sem)
     (np2-   agr type)
     (np3-   agr type)
     (np4-   agr type sem)
     (np5-       type)                               ; do not specify agr here
     (np     agr type sem)                           ; np (noun phrase)
   )                                      

  ; ---------------------------------------------------------------------

  ((n-np (sem (^ (joinS ?s1 ?s2))) )
   -n-np-0->                                                 ; n-np = n + n
     (noun (sem ?s1)) (head (noun (sem ?s2))) )

  ((n-np (sem (^ (joinS ?s1 ?s2))) )
   -n-np-1->                                                 ; n-np = n + n-np
     (noun (sem ?s1)) (head (n-np (sem ?s2))) )

  ; ---------------------------------------------------------------------

  ((n-np2-) -n-np-2-> (head (n-np)))
  ((n-np2-) -n-np-3-> (head (noun))) 

  ; ---------------------------------------------------------------------

  ((adj-n (sem (^ (joinS ?semadj ?semn))) ) 
   -adj-n-2-> 
      (adj (sem ?semadj)) (head (n-np2- (sem ?semn))) )       ; adjn = adj+n
      
  ((adj-n (sem (^ (joinS ?semadj ?semn))) ) 
   -adj-n-3-> 
      (adj (sem ?semadj)) (head (adj-n (sem ?semn))) )        ; adjn = adj+adjn

  ; ---------------------------------------------------------------------
  
  ((np1-) -np-2-> (head (adj-n)))                             ; np = adjn  
  ((np1-) -np-3-> (head (noun)) )

  ; ---------------------------------------------------------------------
       
  ((np2- (sem (^ (joinS ?s1 ?s2)))) -np-4-> 
     (art (agr ?a) (sem ?s1)) (head (np1- (agr ?a) (sem ?s2)))) ; article+noun
  
  ((np2- (sem ?s)) -np-5-> (head (np1- (sem ?s))))              ; simple noun

  ; ---------------------------------------------------------------------
    
  ((pers (sem ?s)) -pers-6-> (head (name (sem ?s))) )
  ((pers (sem (^ (joinS ?s1 ?s2)))) -pers-7-> 
     (head (name (agr ?a) (sem ?s1))) (pers (agr ?a) (sem ?s2))) ; person
  ((np2- (sem ?s)) -np-8-> (head (pers (sem ?s))) )              ; person as np

  ; ---------------------------------------------------------------------

  ((np3- (sem ?s)) -np-9-> (head (np2- (sem ?s))) )              ; np of np
  ((np3- (sem (^ (joinS3 ?s1 "of" ?s2)))) -np-10-> 
     (head (np2- (sem ?s1))) (of) (np3- (sem ?s2)) )

  ; ---------------------------------------------------------------------

  ((persx (sem (^ (joinS3 ?s2 "<TITLE>" ?s1)))) -persx-9->   ; title + person
     (np3- (agr ?a) (sem ?s1) (type obj)) 
     (head (pers (agr ?a) (sem ?s2))) )

  ((persx (sem (^ (joinS3 ?s1 "<TITLE>" ?s2)))) -persx-10->  ; person, title
     (head (pers (agr ?a) (sem ?s1))) ($comma$) 
     (np3- (agr ?a) (sem ?s2) (type obj)))

  ; ---------------------------------------------------------------------

  ((np4-) -np-11-> (head (persx)) )
  ((np4-) -np-12-> (head (np3-)) )                               ; person

  ; ---------------------------------------------------------------------
  
  ((np5- (agr 3p) (sem (^ (joinS3 (quote ?s1) (quote ?s2) (quote ?s3))))) 
    -np-13-> 
      (np4- (sem ?s1)) 
      (conj (always-plural +) (sem ?s2)) 
      (head (np4- (sem ?s3))) )

  ((np5- (agr ?a) (sem (^ (joinS3 (quote ?s1) (quote ?s2) (quote ?s3)))))
   -np-14-> 
     (np4- (sem ?s1)) 
     (conj (always-plural -) (agr ?a) (sem ?s2))             ; conjunction
     (head (np4- (agr ?a) (sem ?s3))) )

  ((np5- (agr ?a) (sem (^ (join3 (quote ?s1) ", " (quote ?s2))))) 
    -np-15-> 
     (np4- (sem ?s1)) ($semis$)
     (head (np5- (agr ?a) (sem ?s2))) )

  ; ---------------------------------------------------------------------

  ((np) -np-16-> (head (np5-)) )
  ((np) -np-17-> (head (np4-)) )

)) ; --- end *np-forms* 


; --------------------- grammar rules/lexicon for VERB Phrases ----------------

(setq *vp-forms*          
 
'( (headfeatures
     (vp vform agr passive)                                 ; vp (verb phrase) 
   )                                      

  ; ---------------------------------------------------------------------

  ((vp (sem (?s))) -vp-1-> 
     (head (verb (subcat _none) (sem ?s))))                 ; simple verbs

  ; ---------------------------------------------------------------------
  
  ((vp (sem (?ev (DO ?d_o))) (last-agr ?a) (last-sem ?d_o))
   -vp-2->                                                  ; verb + np (act)
    (head (verb (subcat _np) (passive -) (sem ?ev)))        ; A kills B
    (np (sem ?d_o) (agr ?a) ))                                  

  ; ---------------------------------------------------------------------
                                                             
  ((vp (sem (?ev))) 
   -vp-3->                                                  ; passive v 
    (head (verb (subcat _np) (passive +) (sem ?ev))) )      ; B is killed

  ; ---------------------------------------------------------------------
  
  ((vp (sem (?ev (DO ?d_o) (DOADJ ?d_o_adj))) ) 
   -vp-4-> 
     (head (verb (subcat _np_adjp) (passive -) (sem ?ev)))    ; v+np+adjp (act)
     (np (sem ?d_o))                                          ; A finds B dead
     (adjp (sem ?d_o_adj)))      

  ; ---------------------------------------------------------------------

  ((vp (sem (?ev (SUBJADJ ?subj_adj))) ) 
   -vp-5->                                                    ; passive
     (head (verb (subcat _np_adjp) (passive +) (sem ?ev) ))   ; B is found dead
     (adjp (sem ?subj_adj) ))

  ; ---------------------------------------------------------------------
  
  ((vp (sem (?ev ?semvp)) ) 
   -vp-6->                                                    ; verb + inf-vp
     (head (verb (subcat _vp-inf) (sem ?ev))) 
     (vp-inf (vform inf) (sem ?semvp) ))     

  ; ---------------------------------------------------------------------
  
  ((vp (sem (?ev (COMMANDEE ?semnp ?semvp))) )
   -vp-7->                                                    ; v+np+ inf-vp
     (head (verb (subcat _np_vp-inf) (sem ?ev)))      
     (np (sem ?semnp)) 
     (vp-inf (vform inf) (sem ?semvp) ))

  ; ---------------------------------------------------------------------
  
  ((vp (sem (?ev (SUBJADJ ?sub_adj))) )
   -vp-8->                                                    ; v + adj phrase
     (head (verb (subcat _adjp) (sem ?ev))) 
     (adjp (sem ?sub_adj) )) 

  ; ---------------------------------------------------------------------
  
  ((vp-inf (vform inf)
    (sem (ACT (^ (cadar (quote ?semvp)))
              (^ (cdr   (quote ?semvp)))  )) )
    -vp-9->                                                       ; to + vp 
      (to) 
      (vp (vform bare) (sem ?semvp)) )

)) ; ---------- *vp-forms* ---  


; ------------------------------------------ sentences --------------------

(setq *sentense-forms*          
 
'( (headfeatures
     (s-tmp   agr passive vform spec)
     (s-tmp2- agr passive vform )
     (s       agr passive vform )                       ; sentenses (s)
     (termin  lex )
   )                      

  ; ---------------------------------------------------------------------

  ((s-tmp (np-found +) (last-agr ?la) (last-sem ?ls)
          (sem (^ (append (list (quote (SUBJ ?semnp)))
                          (quote ?semvp)))) )
    -s-1->                                                     ; s=np + vp
    (np (agr ?a) (sem ?semnp))
    (head (vp (vform (? v pres past)) (agr ?a) (sem ?semvp)
              (last-agr ?la) (last-sem ?ls) )) )

  ; ---------------------------------------------------------------------

  ((s-tmp (np-found -)  (last-agr ?la) (last-sem ?ls)
          (sem (^ (append (quote ?semvp)
                          (list (quote ?sempp))))) )
    -s-2->                                                  ; s (without np)
    (pp (sem ?sempp)) ($comma$) 
    (head (vp (vform (? v pres past)) (sem ?semvp) 
              (last-agr ?la) (last-sem ?ls) )) )

  ; ---------------------------------------------------------------------
    
  ((s-tmp (np-found +) (last-agr ?la) (last-sem ?ls)
          (sem (^ (append (quote ?semS)
                          (list (quote (SUBJ ?semnp))) ))) )
    -s-3->                                              ; we have found the np
     (np (agr ?a) (sem ?semnp)) ($comma$) 
     (head (s-tmp (np-found -) (agr ?a) (sem ?semS)
                  (last-agr ?la) (last-sem ?ls) )) )

  ; ---------------------------------------------------------------------

  ((s-tmp (np-found ?f) (last-agr ?la) (last-sem ?ls)
      (sem (^ (append (quote ?semS)
                      (list (quote ?sempp))))) )
    -s-4->                                              ; add pp in front
    (pp (sem ?sempp)) ($comma$) 
    (head (s-tmp (np-found ?f) (sem ?semS) 
                 (last-agr ?la) (last-sem ?ls) )) )

  ; ---------------------------------------------------------------------

  ((s-tmp2- (np-found ?f) (sem ?s) (spec ?sp)
            (last-agr ?la) (last-sem ?ls) )
    -s-5->                                             ; finished add in front
     (head (s-tmp (np-found ?f) (sem ?s) (spec ?sp)
                  (last-agr ?la) (last-sem ?ls) )) )

  ; ---------------------------------------------------------------------

  ((s-tmp2- (np-found +) (last-agr ?la) (last-sem ?ls) 
            (spec that-clause) 
            (sem (^ (append (list (quote (SUBJ "--subj--")))
                            (quote ?semvp)))) )
    -s-6->                                             ; "that" clause 
    (head (vp (vform (? v pres past)) (sem ?semvp)     ; pretend subj is found
              (last-agr ?la) (last-sem ?ls) )) )

  ; ---------------------------------------------------------------------
    
  ((s-tmp2- (np-found ?f) (sem (^ (append (quote ?semvp)
                           (list (quote ?sempp)))))
            (last-agr ?la) (last-sem ?ls) (spec ?sp)) 
   -s-7->                                                  ; add pp on back
    (head (s-tmp2- (np-found ?f) (sem ?semvp) (spec ?sp))) 
    (pp (sem ?sempp) (last-agr ?la) (last-sem ?ls) ))

  ; ---------------------------------------------------------------------

  ((s-tmp2- (np-found ?f) (sem (^ (append (quote ?semvp)
                                  (list (quote ?sempp)))))
            (last-agr ?la) (last-sem ?ls) (spec ?sp)) 
   -s-8->                                              ; add pp on back (comma)
    (head (s-tmp2- (np-found ?f) (sem ?semvp) (spec ?sp))) 
    ($comma$) (pp (sem ?sempp) (last-agr ?la) (last-sem ?ls) ) )

  ; ---------------------------------------------------------------------
  
  ((termin (ending period))    -term-1-> (head ($period$)) )     ; terminators
  ((termin (ending that-subj)) -term-2-> (head (that-subj)) )    ; remember to
  ((termin (ending when-conj)) -term-3-> (head (when-conj)) )    ; SYNC 

  ; ---------------------------------------------------------------------

  ((s (ending ?en) (spec ?sp) (last-agr ?la) (last-sem ?ls)
      (sem (^ (subst 'TARGET    'DO   
              (subst 'TARGET-IS 'DOADJ 
              (subst 'AGENT-IS  'SUBJADJ
              (subst 'AGENT     'SUBJ (quote ?s))))))) )
    -s-10->                                                 ; Active Sentense
     (head (s-tmp2- (np-found +) (passive -) (sem ?s)
                     (last-agr ?la) (last-sem ?ls) (spec ?sp)))
     (termin (ending ?en)) )

  ; ---------------------------------------------------------------------

  ((s (ending ?en) (spec ?sp) (last-agr ?la) (last-sem ?ls)
      (sem (^ (subst 'TARGET    'SUBJ   
              (subst 'TARGET-IS 'SUBJADJ
              (subst 'AGENT     'CAUSED_BY (quote ?s)))))) )
   -s-11->                                                  ; Passive Sentense
    (head (s-tmp2- (np-found +) (passive +) (sem ?s)
                   (last-agr ?la) (last-sem ?ls) (spec ?sp))) 
    (termin (ending ?en)) )

  ; ---------------------------------------------------------------------
  ; e.g.    A  that B that C
  ; we want to associate B and C first. 

  ((s (ending ?en) (last-agr ?la) (last-sem ?ls) (spec ?sp)
      (sem (^ (list (quote ?left-s)
                    '<----same-object---->
                    (subst (quote ?last-s) "--subj--"
                           (quote ?right-s) :test #'equal)))) )
   -s-12->                                       
    (head (s (sem ?left-s)                                  ; THAT sentences
             (last-agr ?last-a) (last-sem ?last-s) 
             (ending that-subj) (spec ?sp) ))
    (s       (sem ?right-s) (agr ?last-a) 
             (last-agr ?la) (last-sem ?ls) 
             (spec that-clause)                       ; Right-associated
             (ending (? en period when-conj))         ; sync terminator set
             ))

  ; ---------------------------------------------------------------------
  ; WHEN has lower priority than THAT

  ((s (ending ?en) (last-agr ?la) (last-sem ?ls) (spec -)
      (sem (^ (list (quote ?left-s)
                    '<----same-time---->
                    (quote ?right-s)))) )
   -s-13->                                                  ; WHEN sentences
    (head (s (sem ?left-s) (vform ?vf)           
             (ending when-conj) (spec -) ))
    (s       (sem ?right-s)  
             (last-agr ?la) (last-sem ?ls) 
             (spec -) (vform ?vf) 
             (ending (? en period))         ; wait until all THATs are done
             ))


  ; ---------------------------------------------------------------------

 ) 
)  ; ----- sentense-forms 

                               
; ---------------------- CREATE DATABASE --------------------------------

(make-grammar *general-forms*)
(make-lexicon *general-lexicon*)

(augment-grammar *verb-forms*)
(augment-grammar *passive-forms*)
(augment-lexicon *verb-lexicon*)

(augment-grammar *noun-forms*)
(augment-lexicon *noun-lexicon*)

(augment-grammar *adj-forms*)
(augment-lexicon *adj-lexicon*)

(augment-grammar *adv-forms*)
(augment-lexicon *adv-lexicon*)

(augment-grammar *prep-forms*)
(augment-lexicon *prep-lexicon*)

(augment-grammar *np-forms*)
(augment-grammar *vp-forms*)

(augment-grammar *sentense-forms*)

;(defun x () 2) 
;(x)

;xxxxx ..... 


(Format t "~%-----------  Words defined are ~%~%~s~%~%" (defined-words))


; ---------------- testing ----------------------------------------

; (load "hw2.lisp")

;(p '(ricardo alfonso castellar $comma$ the dog))  ; persx
;(p '(was want +ed))                               ; passive, past 
;(p '(is happy))                                   ; v + adj
;(p '(want +s to cry))                             ; v + inf
;(p '(want +s ricardo to cry))                     ; v + np + inf
;(p '(was seeing ricardo))                         ; progressive 
;(p '(has been want +ed))                          ; passive, perfect 
;(p '(according to))                               ; preposition (composite)
;(p '(department +al))                             ; adj (composite)
;(p '(want +s a dog ))                             ; v + np (active)
;(p '(a dog was want +ed $period$))                ; v(passive) [no np]
;(p '(apparent +ly))                               ; adv (composite)
;(p '(department +al +ly ))                        ; adv (super composite)
;(p '(ricardo))                                    ; pronoun as noun
;(p '(according to))                               ; composite preposition
;(p '(according to his dog))                       ; pp-> prep+ adj + n
;(p '(5 january))                                  ; time expression
;(p '(on 5 january))                               ; time preposition

;(p '(ricardo cry +ed $period$))                     ; simple sentense (np vp)
;(p '(ricardo cry +ed on 5 january $period$))               ; np vp pp
;(p '(ricardo cry +ed on 5 january to the dog $period$))    ; np vp pp pp
;(p '(in bolivar $comma$ ricardo cry +ed))                  ; pp, np vp
;(p '(ricardo $comma$ in bolivar $comma$ cry +ed $period$)) ; vp, pp, vp

;(p '(ricardo kill +s dog $period$))
;(p '(dog is kill +ed by ricardo $period$))

;(p '(want +s the man to kill the dog)) 
;(p '(the man $comma$ in bolivar $comma$ cry +s))
;(p '(in bolivar $comma$ to department $comma$ cry +s))
;(p '(in bolivar $comma$ to department $comma$ cry +s on the dog))
;(p '(the man $comma$ in bolivar $comma$ to department $comma$ cry +s on dog))

; -------------------------------

;(p '(in the northern department of bolivar))            ; long prep. phra (pp)
;(p '(ricardo alfonso castellar $comma$ mayor of achi))  ; person name/title
;(p '(ricardo was kidnap +ed on 5 january $period$))   
;(p '(ricardo cry +s apparent +ly $period$))   

(setf *s1* '(ricardo alfonso castellar $comma$ mayor of achi $comma$ 
             in the northern department of bolivar $comma$ 
             was kidnap +ed on 5 january
             apparent +ly by eln guerrilla +s
             $period$)) 

;(p '(man find +s dog stupid $period$))
;(p '(dog is found stupid by man $period$))
;(p '(he was found dead $period$))
;(p '(he was found dead according to authorities $period$))
;(p '(he cry +s $comma$ today $period$ ))

(setf *s2* '(he was found dead today $comma$ according to authorities
		$period$)) 

;(p '(castellar is the second mayor that))
;(p '(man is dog that cry +s $period$))
;(p '(castellar is the second mayor that has been murder +ed $period$))
;(p '(in the last 3 day +s $period$))

(setf *s3* '(castellar is the second mayor that has been murder +ed in
		       colombia in the last 3 day +s $period$)) 
		       
(setf *s4* '(on 5 january $comma$ carlos julio torrado $comma$ mayor
		of abrego $comma$ in the northeastern department of santander
		$comma$ was kill +ed apparent +ly by another guerrilla
		column of the eln $period$)) 

;(p '(the stupid bodyguard jacome))
;(p '(dog $semi$ man and mayor))
;(p '(gustavo $semi$ torrado and quintero))

;(p '(william torrado $comma$ the son of carlos $semi$ 
;    gustavo jacome quintero $comma$ the department +al government secretary 
;    and bodyguard jairo ortega ))

(setf *s5* '(william torrado $comma$ the son of carlos $semi$ gustavo
		     jacome quintero $comma$ the department +al
		     government secretary and bodyguard jairo
		     ortega were also kill +ed $period$)) 

;(p '(the group was travel +ing in a 4-wheel drive vehicle $period$))
;(p '(between cucuta and the rural area))
;(p '(the man cry +ed when the dog die +ed $period$))
;(p '(their vehicle was blown up by four explosive charge +s $period$ ))
;(p '(man was blown up by dog $period$))
;(p '(MAN KILL +S DOG THAT KILL +S CHARGE that kill +s man $period$))

(setf *s6* '(the group was travel +ing in a 4-wheel drive vehicle
		 between cucuta and the rural area
		 when their vehicle was blown up by four explosive
		 charge +s that detonate +ed on the highway $period$)) 

(set-best-first)
(traceoff)
(p *s1*)
(p *s2*)
(p *s3*)
(p *s4*)
(p *s5*)
(p *s6*)


;---- take this away.  We want to come out with a better way to 
; handle recursive sentences 
; -- known as campanario (from sentense 6)
;
; the book [that is] known as Robots by Issac Issimov 
;         


