// -------------------------------- common.cc ------------------------------
// common definitions
// Jui-Yuan Fred Hsu.  May 1995 
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include <stdio.h>
#include "common.h"          // common definitions


struct Pair
{
  int   index;
  char *name;
};

Pair cats[] = 
  {
    { CAT_SELF, "self" }, { CAT_CORR, "corr" }, { CAT_ROOT, "root" }, 
    { CAT_PREF, "pref" }, { CAT_SUFF, "suff" }, { CAT_GSUF, "gsuf" }, 
    { 0,        NULL }
  };

Pair subs[] = 
  {
    { SUB_NOUN,       "s_noun" }, 
    { SUB_ADJ,        "s_adj" }, 
    { SUB_ADV,        "s_adv" }, 
    
    { SUB_VERB_INTR,  "s_verb_intr" }, 
    { SUB_VERB_TRAN,  "s_verb_tran" }, 
    
    { SUB_INTERJ,     "s_interj" }, 
    { SUB_CONJUNC,    "s_conjunc" }, 
    { SUB_SUBJUNC,    "s_subjunc" }, 
    { SUB_CONJUNC_X,  "s_conjunc_x" }, 
    
    { SUB_PRON_DEMON, "s_pron_demon" },
    { SUB_PRON_PERS,  "s_pron_pers" }, 
  
    { SUB_MORF_KTP,   "s_morf_ktp" }, 
    { SUB_MORF_KE,    "s_morf_ke" }, 
    { SUB_MORF_J,     "s_morf_j" }, 
    { SUB_MORF_N,     "s_morf_n" }, 
    
    { SUB_NUM,        "s_num" }, 
    
    { SUB_ADJ_DEMON,  "s_adj_demon" }, 

    { SUB_END_OM,     "s_end_om" },
    { SUB_END_WORDS,  "s_end_words" }, 
    { SUB_END_VERBS,  "s_end_verbs" }, 

    { SUB_PREP,       "s_prep" },   
  
    { SUB_PROPER,     "s_proper" },
  
    { 0, NULL }
  };


char * cat_names[256];
char * sub_names[256];

char* punc_c[PUNC_NUM]   = { ",", ".", ";", "'" };
char* punc_str[PUNC_NUM] = { "$comma$", "$period$", "semi$", "$apost$" }; 


// ---------------------- common_init -------------------------------------
// This must be called when program starts
// ----------------------------------------------------------------------
void  common_init()
{
  int i;
  
  for (i=0; i<256; i++) cat_names[i]=NULL;
  for (i=0; i<256; i++) sub_names[i]=NULL;

  for (i=0; cats[i].name!=NULL; i++)
    cat_names[CATEGS_STR[cats[i].index]] = cats[i].name;
    
  for (i=0; subs[i].name!=NULL; i++)
    sub_names[SUBS_STR[subs[i].index]] = subs[i].name;
}


// ---------------------- CatName -------------------------------------
// return string name for a category (input a category character)
// ----------------------------------------------------------------------
char* CatName(char cat_char)
{
  return cat_names[cat_char]; 
}


// ---------------------- SubName -------------------------------------
// return string name for a sub-category 
// ----------------------------------------------------------------------
char* SubName(char sub_char)
{
  return sub_names[sub_char];
}

  






