// ------------------- common.h -------------------------------------
// common definitions
// Jui-Yuan Fred Hsu.  May 1995 
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef _COMMON_H_
#define _COMMON_H_

// ----- the macros INPUT_VORTARO, etc. must be defined in Makefile ----


#define  N_CATEGS       6
#define  CATEGS_STR     "wcrpsg"

#define  CAT_SELF       0
#define  CAT_CORR       1
#define  CAT_ROOT       2
#define  CAT_PREF       3
#define  CAT_SUFF       4
#define  CAT_GSUF       5

#define  N_SUBS         22
#define  SUBS_STR       "oaeiI!KLmMNORjklnrsuzy"

#define  SUB_NOUN		0
#define  SUB_ADJ		1
#define  SUB_ADV		2
#define  SUB_VERB_INTR		3
#define  SUB_VERB_TRAN		4
#define  SUB_INTERJ		5
#define  SUB_CONJUNC		6
#define  SUB_PRON_DEMON		7
#define  SUB_PRON_PERS		8
#define  SUB_MORF_KTP		9
#define  SUB_NUM 		10
#define  SUB_END_OM		11
#define  SUB_MORF_KE		12
#define  SUB_MORF_J		13
#define  SUB_SUBJUNC		14
#define  SUB_ADJ_DEMON		15
#define  SUB_MORF_N		16
#define  SUB_END_WORDS		17
#define  SUB_END_VERBS		18
#define  SUB_PREP		19
#define  SUB_CONJUNC_X		20
#define  SUB_PROPER		21


#define  COL_ESP        0
#define  COL_CAT        1
#define  COL_SUB        2
#define  COL_ENG        3

#define  FIL_CAT        0
#define  FIL_SUB        1
#define  FIL_ESP        2


#define  PUNC_NUM  4

extern char* punc_c[PUNC_NUM]; 
extern char* punc_str[PUNC_NUM]; 


void  common_init();

char* CatName(char cat_char); 
char* SubName(char sub_char);

#endif

