// -------------------------- glue.cc --------------------------------------
// reverse of lispify.cc
// glue affixes back to root
// Jui-Yuan Fred Hsu.  May 1995 
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// ----------------------------------------------------------------------

#include  "Debug.h"
#undef    LOCAL_DEBUG
#define   LOCAL_DEBUG  0

#include "common.h"          // common definitions
#include "str.h"             // String class

#include <fstream.h>         // file stream processing


// ---------------------- check_punc -------------------------------------
// check string for punctuation
// If it's not punctuation, return NULL
// If it's punctuation  return ptr to the character for this punctuation
// ----------------------------------------------------------------------
char * check_punc(char *str)
{
  for (int i=0; i<PUNC_NUM; i++)
    if (strcmp(punc_str[i], str)==0) return punc_c[i];
  return NULL;
}


// ---------------------- main -------------------------------------
// ----------------------------------------------------------------------
int main()
{
  Str    buf;
  char   *str, *res;
  int    len;
  int    complete=0;
  
  while (cin >>ws>>buf, ! cin.eof())
   {
     str = buf;
     len = strlen(str); 
     if (len==0) continue;
     
     if ( (res=check_punc(str)) !=NULL)         // convert punctuations
      {
        cout <<res;
        complete =1; 
      }
      
     else if (strcmp(str, "+")==0)              // joining two roots
      {
        complete =0; 
      }
      
     else if (str[len-1]=='+')                  // prefix 
      {
        if (complete) cout <<' ';
        str[len-1]=0;
        cout <<str; 
        complete =0;
      }
      
     else if (str[0]=='+')                       // suffix
      {
        cout <<str+1; 
        complete =1; 
      }
      
     else                                        // normal words
      {
        if (complete) cout <<' ';
        cout <<str;
        complete =1;
      }
    }
    
  cout <<endl;

  return 0;
}






