// ---------------- Debug.h --------------------------------
// Jui-Yuan Fred Hsu.  May 1995 
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// April 95.  Copied from Aaron.


#ifndef CCPDEBUGTOOLS_H
#define CCPDEBUGTOOLS_H

#include <iostream.h>
#include <stdlib.h>

/*
There are three ways to control the display of debugging info 
(listed in order of precedence:)

 (1) If NDEBUG is defined _before_this_file_is_included, 
     the debugging messages will
     never be displayed and there will be no run-time cost.
     If you include this file from a .C, this works fine.  
     On the other hand, if you define
     NDEBUG in a .h, it will cascade through more files than you probably want.
     It's probably best to think of this as a compiler option 
     (to be set with -DNDEBUG).
     (NDEBUG overrides the next two options.)

     Note that NDEBUG is a standard symbol: for example, if NDEBUG is defined,
      assert.h will remove all assert() calls.

 (2) If you don't define NDEBUG, you can control when a debug message 
     gets displayed by redefining LOCAL_DEBUG to 1 or 0 as needed.
     On a good optimizing compilier, this too will result in no runtime penalty,
     but on a dumb compiler, it will cost you an extra comparison per use.
     This is the technique I use to get rid of annoying messages from files
     I'm not working with.

 (3) As always, the user can set RUNTIME_DEBUG to a global variable,
     and set this var to 1 at runtime.
     This variable has to be set before this file is included
*/

#ifndef RUNTIME_DEBUG 
#define RUNTIME_DEBUG  1 
#endif


#ifndef NDEBUG 
#define LOCAL_DEBUG 1

#define IFDEBUG	if ( LOCAL_DEBUG && RUNTIME_DEBUG )

#define DUMP(x) IFDEBUG { cout << __FILE__ "\t" << __LINE__         \
                               << ":\t" #x " == " << x << endl; }

#define LINENO  IFDEBUG { cout << __FILE__ "\t" << __LINE__         \
                               << ":\t(LINENO)" << endl; }

#define MSG(x)  IFDEBUG { cout << __FILE__ "\t" << __LINE__         \
                               << ":\t" << x << endl; }

#define MESG(x) IFDEBUG { cout <<  x << endl; }

#define MESGx(x) IFDEBUG { cout <<  x ; }


#else  // NO_LOCAL_DEBUG is defined

#define LOCAL_DEBUG 0
#define IFDEBUG if ( 0 )
#define DUMP(x) {}
#define LINENO  {}
#define MSG(x)  {}
#define MESG(x) {}

#endif // NDEBUG


#define EXIT(x) { cout << __FILE__ "\t" << __LINE__             \
                       << ":\tPROGERROR( " << x << ")" << endl; \
                  exit(1);                                      \
		}

#define ASSERT(expr) \
	if (!(expr)) { \
	    cout << __FILE__ "\t" << __LINE__ << ":\t ASSERTION ( "  \
	    << #expr << " ) failed...Programmer error.  Debug now." << endl; \
	    exit( -1 ); \
	}

#define ASSERTWARN(expr) \
	if (!(expr)) { \
	    cout << __FILE__ "\t" << __LINE__ << ":\t ASSERTION ( "  \
	    << #expr << " ) failed...WARNING." << endl; \
	}

#endif  // CCPDEBUGTOOLS_H
