// ---------------------------- str.cc ------------------------------------
// A string class (for Collect.h)
// Jui-Yuan Fred Hsu.  May 1995 
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "str.h"

#include  "Debug.h"
#undef    LOCAL_DEBUG
#define   LOCAL_DEBUG  0


// ------------------- read_buf-----------------------------------------
// don't know why, but this thing has to be a char*.
// If we use char[], then >> won't work (even if typecasted to char*)

CharPtr Str:: read_buf = new char [MAX_READ_LEN+3];


// ------------------- = operators ---------------------------------------
// -------------------------------------------------------------------------
Str& Str:: operator = (Str& s)
{
  return *this = s.str;
}

Str& Str:: operator = (CharPtr s)
{
  MESG("Str:operator=(char* s)  s="<<s);
  if (str) { MESG("  this->str="<<str); }
  else     { MESG("  this->str=NULL"); }

  if (str) delete str; 

  if (s==NULL) 
   {
     str=new char[3];
     str[0]=0;
     len=0;
   }
  else
   {
     len = strlen(s);
     str = new char [len+3];
     strcpy(str, s);
   }

  MESG("  final this->str="<<str<<"  len="<<len);

  return *this;
}


