// ---------------------------- str.h ------------------------------------
// A string class (for Collect.h)
// Jui-Yuan Fred Hsu.  May 1995 
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef STR_FRED_H_
#define STR_FRED_H_

#include <string.h>
#include <fstream.h>
#include <iomanip.h>

typedef  char*  CharPtr;

#define MAX_READ_LEN  100     

class Str
{
  private:
  
    CharPtr str;          // we own this string 
    int     len;
  
    static  CharPtr read_buf;
  
  public: 

    Str& operator =(CharPtr s);
    Str& operator =(Str& s);
    
    Str(CharPtr s=NULL) { str=NULL; *this = s; }
    Str(Str& s)         { str=NULL; *this = s; }
    ~Str()              { if (str) delete str; }

    operator CharPtr() { return str; }            // type casting to char*
    
    int Len() { return len; }
    
    inline friend int operator == (const Str& s1, const Str& s2)
                                  { return strcmp(s1.str, s2.str) ==0; }
    
    inline friend ostream& operator << (ostream&os, const Str& s) 
                                       { return os<<s.str; }
    
    inline friend istream& operator >> (istream&is, Str& s) 
     { 
       is >>setw(MAX_READ_LEN) >>Str::read_buf; 
       s = Str::read_buf;
       return is; 
     }
                                       
};


#endif
