// --------------------------- strtok.h ------------------------------------
// string token object receives a string, and parses it into tokens.
// tokens are separated by one or more SEPARATORS
// Jui-Yuan Fred Hsu.  May 1995 
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef _STRTOK_H_
#define _STRTOK_H_

#include <string.h>

#define STRTOK_SEPARATORS  " \t"
#define MAX_N_TOKENS       30

#define STRTOK_DEFAULT_SIZE 1000



class StrTok
{
  private:
  
    char * str;                     // owns this string 
    
    char * toks[MAX_N_TOKENS];      // token pointers into <str>
    int    n_toks;                  // number of tokens

    int    buf_size;                // used in add()

  public:
  
    StrTok(char *s="", int b_size=STRTOK_DEFAULT_SIZE)
                       { str=NULL; n_toks=0; set(s, b_size); }
    
    StrTok(StrTok& s)  { str=NULL; n_toks=0; *this=s; }
    ~StrTok()          { if (str) delete str; }
    
    StrTok& operator=(StrTok& s) 
     {
       buf_size = s.buf_size;

       if (s.n_toks==0) { set(NULL); return *this; }
       
       char *ptr = s.toks[s.n_toks-1];
       int n = ptr - s.str + strlen(ptr);
       
       str = new char [n + 3];
       for (int j=0; j<=n; j++) str[j]=s.str[j];
       
       for (int i=0; i<s.n_toks; i++)
         toks[i] = s.toks[i]-s.str + str;
         
       n_toks=s.n_toks;
       return *this; 
     }
       
    void set(char *s, int b_size = STRTOK_DEFAULT_SIZE ) 
     { 
       buf_size = b_size;
      
       if (str) delete str; 

       if (s==NULL || strlen(s)==0) 
         { str=NULL; n_toks=0; return; }

       str = new char[ strlen(s)+1 ];
       strcpy(str, s);
       parse();
     }

    char * get() const { if (n_toks!=0) return str; else return ""; }

    int num() const { return n_toks; }
    
    char * operator[] (int i) { if (i<n_toks) return toks[i]; else return ""; }


    // ------- careful!! must make sure that when set(), has given it 
    //         a very big array

    void add(char *sub)
     {
       if (n_toks+1 >=MAX_N_TOKENS) return;
       if (sub==NULL || strlen(sub)==0) return;
       
       if (n_toks==0) toks[n_toks] = str = new char[buf_size+3];
       else           toks[n_toks] = toks[n_toks-1]+strlen(toks[n_toks-1])+1;
       *toks[n_toks]=0; 
       strcpy(toks[n_toks], sub);
       n_toks++;
     }


    inline friend int operator == (const StrTok& s1, const StrTok& s2)
                 { return strcmp(s1.str, s2.str) ==0; } // compare first token
    
    inline friend ostream& operator << (ostream&os, const StrTok& s) 
     {
       for (int i=0; i<s.num(); i++)
         os << s.toks[i] <<' '; 
       return os <<endl;
     }
    
    inline friend istream& operator >> (istream&is, StrTok& s) 
     { 
       char buf[s.buf_size+3]; 
       is.getline(buf, s.buf_size);  
       s = buf;
       return is; 
     }
       
  private:
  
    parse()
     {
       n_toks=0; 
       char * s1  = str;
       char * s2  = STRTOK_SEPARATORS;
       char * ptr = strtok(s1, s2);
       
       while (ptr && n_toks<MAX_N_TOKENS)
        {
          toks[n_toks++] = ptr;
          ptr = strtok(NULL, s2);
        }
     }
};

#endif _STRTOK_H_

/* ---------------------- history ------------

4/??/95: created it

4/29/95: make it a class for Collect

4/29/95: added data member buf_size, and modified add(), set(), etc

*/


